/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.commands.sub;

import com.grinderwolf.swm.plugin.commands.sub.Subcommand;
import com.grinderwolf.swm.plugin.log.Logging;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UnloadWorldCmd
implements Subcommand {
    private final String usage = "unload <world>";
    private final String description = "Unload a world.";
    private final String permission = "swm.unloadworld";

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length > 0) {
            World world = Bukkit.getWorld((String)args[0]);
            if (world == null) {
                sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.RED + "World " + args[0] + " is not loaded!");
                return true;
            }
            List players = world.getPlayers();
            if (!players.isEmpty()) {
                World defaultWorld = (World)Bukkit.getWorlds().get(0);
                Location spawnLocation = defaultWorld.getSpawnLocation();
                while (spawnLocation.getBlock().getType() != Material.AIR || spawnLocation.getBlock().getRelative(BlockFace.UP).getType() != Material.AIR) {
                    spawnLocation.add(0.0, 1.0, 0.0);
                }
                for (Player player : players) {
                    player.teleport(spawnLocation);
                }
            }
            if (Bukkit.unloadWorld((World)world, (boolean)true)) {
                sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.GREEN + "World " + ChatColor.YELLOW + args[0] + ChatColor.GREEN + " unloaded correctly.");
            } else {
                sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.RED + "Failed to unload world " + args[0] + ".");
            }
            return true;
        }
        return false;
    }

    @Override
    public String getUsage() {
        return this.usage;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getPermission() {
        return this.permission;
    }
}

