/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.loaders;

import com.github.luben.zstd.Zstd;
import com.grinderwolf.swm.api.exceptions.CorruptedWorldException;
import com.grinderwolf.swm.api.exceptions.NewerFormatException;
import com.grinderwolf.swm.api.loaders.SlimeLoader;
import com.grinderwolf.swm.api.utils.NibbleArray;
import com.grinderwolf.swm.api.utils.SlimeFormat;
import com.grinderwolf.swm.api.world.SlimeChunk;
import com.grinderwolf.swm.api.world.SlimeChunkSection;
import com.grinderwolf.swm.api.world.properties.SlimePropertyMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.DoubleTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.IntArrayTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.IntTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ListTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.TagType;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.stream.NBTInputStream;
import com.grinderwolf.swm.internal.com.mongodb.MongoException;
import com.grinderwolf.swm.nms.CraftSlimeChunk;
import com.grinderwolf.swm.nms.CraftSlimeChunkSection;
import com.grinderwolf.swm.nms.CraftSlimeWorld;
import com.grinderwolf.swm.plugin.config.ConfigManager;
import com.grinderwolf.swm.plugin.config.DatasourcesConfig;
import com.grinderwolf.swm.plugin.loaders.UpdatableLoader;
import com.grinderwolf.swm.plugin.loaders.file.FileLoader;
import com.grinderwolf.swm.plugin.loaders.mongo.MongoLoader;
import com.grinderwolf.swm.plugin.loaders.mysql.MysqlLoader;
import com.grinderwolf.swm.plugin.log.Logging;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class LoaderUtils {
    public static final long MAX_LOCK_TIME = 300000L;
    public static final long LOCK_INTERVAL = 60000L;
    private static Map<String, SlimeLoader> loaderMap = new HashMap<String, SlimeLoader>();

    public static void registerLoaders() {
        DatasourcesConfig.MongoDBConfig mongoConfig;
        DatasourcesConfig config = ConfigManager.getDatasourcesConfig();
        DatasourcesConfig.FileConfig fileConfig = config.getFileConfig();
        LoaderUtils.registerLoader("file", new FileLoader(new File(fileConfig.getPath())));
        DatasourcesConfig.MysqlConfig mysqlConfig = config.getMysqlConfig();
        if (mysqlConfig.isEnabled()) {
            try {
                LoaderUtils.registerLoader("mysql", new MysqlLoader(mysqlConfig));
            }
            catch (SQLException ex) {
                Logging.error("Failed to establish connection to the MySQL server:");
                ex.printStackTrace();
            }
        }
        if ((mongoConfig = config.getMongoDbConfig()).isEnabled()) {
            try {
                LoaderUtils.registerLoader("mongodb", new MongoLoader(mongoConfig));
            }
            catch (MongoException ex) {
                Logging.error("Failed to establish connection to the MongoDB server:");
                ex.printStackTrace();
            }
        }
    }

    public static SlimeLoader getLoader(String dataSource) {
        return loaderMap.get(dataSource);
    }

    public static void registerLoader(String dataSource, SlimeLoader loader) {
        if (loaderMap.containsKey(dataSource)) {
            throw new IllegalArgumentException("Data source " + dataSource + " already has a declared loader!");
        }
        if (loader instanceof UpdatableLoader) {
            try {
                ((UpdatableLoader)loader).update();
            }
            catch (UpdatableLoader.NewerDatabaseException e) {
                Logging.error("Data source " + dataSource + " version is " + e.getDatabaseVersion() + ", while this SWM version only supports up to version " + e.getCurrentVersion() + ".");
                return;
            }
            catch (IOException ex) {
                Logging.error("Failed to check if data source " + dataSource + " is updated:");
                ex.printStackTrace();
                return;
            }
        }
        loaderMap.put(dataSource, loader);
    }

    public static CraftSlimeWorld deserializeWorld(SlimeLoader loader, String worldName, byte[] serializedWorld, SlimePropertyMap propertyMap, boolean readOnly) throws IOException, CorruptedWorldException, NewerFormatException {
        DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(serializedWorld));
        try {
            CompoundTag mapsCompound;
            CompoundTag extraCompound;
            CompoundTag tileEntitiesCompound;
            SlimeChunk chunk;
            long chunkKey;
            int chunkZ;
            int chunkX;
            Object entityCompound;
            boolean hasEntities;
            byte[] fileHeader = new byte[SlimeFormat.SLIME_HEADER.length];
            dataStream.read(fileHeader);
            if (!Arrays.equals(SlimeFormat.SLIME_HEADER, fileHeader)) {
                throw new CorruptedWorldException(worldName);
            }
            byte version = dataStream.readByte();
            if (version > 9) {
                throw new NewerFormatException(version);
            }
            byte worldVersion = version >= 6 ? dataStream.readByte() : (version >= 4 ? (byte)(dataStream.readBoolean() ? 4 : 1) : (byte)0);
            short minX = dataStream.readShort();
            short minZ = dataStream.readShort();
            short width = dataStream.readShort();
            short depth = dataStream.readShort();
            if (width <= 0 || depth <= 0) {
                throw new CorruptedWorldException(worldName);
            }
            int bitmaskSize = (int)Math.ceil((double)(width * depth) / 8.0);
            byte[] chunkBitmask = new byte[bitmaskSize];
            dataStream.read(chunkBitmask);
            BitSet chunkBitset = BitSet.valueOf(chunkBitmask);
            int compressedChunkDataLength = dataStream.readInt();
            int chunkDataLength = dataStream.readInt();
            byte[] compressedChunkData = new byte[compressedChunkDataLength];
            byte[] chunkData = new byte[chunkDataLength];
            dataStream.read(compressedChunkData);
            int compressedTileEntitiesLength = dataStream.readInt();
            int tileEntitiesLength = dataStream.readInt();
            byte[] compressedTileEntities = new byte[compressedTileEntitiesLength];
            byte[] tileEntities = new byte[tileEntitiesLength];
            dataStream.read(compressedTileEntities);
            byte[] compressedEntities = new byte[]{};
            byte[] entities = new byte[]{};
            if (version >= 3 && (hasEntities = dataStream.readBoolean())) {
                int compressedEntitiesLength = dataStream.readInt();
                int entitiesLength = dataStream.readInt();
                compressedEntities = new byte[compressedEntitiesLength];
                entities = new byte[entitiesLength];
                dataStream.read(compressedEntities);
            }
            byte[] compressedExtraTag = new byte[]{};
            byte[] extraTag = new byte[]{};
            if (version >= 2) {
                int compressedExtraTagLength = dataStream.readInt();
                int extraTagLength = dataStream.readInt();
                compressedExtraTag = new byte[compressedExtraTagLength];
                extraTag = new byte[extraTagLength];
                dataStream.read(compressedExtraTag);
            }
            byte[] compressedMapsTag = new byte[]{};
            byte[] mapsTag = new byte[]{};
            if (version >= 7) {
                int compressedMapsTagLength = dataStream.readInt();
                int mapsTagLength = dataStream.readInt();
                compressedMapsTag = new byte[compressedMapsTagLength];
                mapsTag = new byte[mapsTagLength];
                dataStream.read(compressedMapsTag);
            }
            if (dataStream.read() != -1) {
                throw new CorruptedWorldException(worldName);
            }
            Zstd.decompress(chunkData, compressedChunkData);
            Zstd.decompress(tileEntities, compressedTileEntities);
            Zstd.decompress(entities, compressedEntities);
            Zstd.decompress(extraTag, compressedExtraTag);
            Zstd.decompress(mapsTag, compressedMapsTag);
            Map<Long, SlimeChunk> chunks = LoaderUtils.readChunks(worldVersion, version, worldName, minX, minZ, width, depth, chunkBitset, chunkData);
            CompoundTag entitiesCompound = LoaderUtils.readCompoundTag(entities);
            if (entitiesCompound != null) {
                ListTag entitiesList = (ListTag)entitiesCompound.getValue().get("entities");
                Iterator iterator = entitiesList.getValue().iterator();
                while (iterator.hasNext()) {
                    entityCompound = (CompoundTag)iterator.next();
                    ListTag<?> listTag = ((CompoundTag)entityCompound).getAsListTag("Pos").get();
                    chunkX = LoaderUtils.floor(((DoubleTag)listTag.getValue().get(0)).getValue()) >> 4;
                    chunkZ = LoaderUtils.floor(((DoubleTag)listTag.getValue().get(2)).getValue()) >> 4;
                    chunkKey = (long)chunkZ * Integer.MAX_VALUE + (long)chunkX;
                    chunk = chunks.get(chunkKey);
                    if (chunk == null) {
                        throw new CorruptedWorldException(worldName);
                    }
                    chunk.getEntities().add((CompoundTag)entityCompound);
                }
            }
            if ((tileEntitiesCompound = LoaderUtils.readCompoundTag(tileEntities)) != null) {
                ListTag tileEntitiesList = (ListTag)tileEntitiesCompound.getValue().get("tiles");
                entityCompound = tileEntitiesList.getValue().iterator();
                while (entityCompound.hasNext()) {
                    CompoundTag tileEntityCompound = (CompoundTag)entityCompound.next();
                    chunkX = ((IntTag)tileEntityCompound.getValue().get("x")).getValue() >> 4;
                    chunkZ = ((IntTag)tileEntityCompound.getValue().get("z")).getValue() >> 4;
                    chunkKey = (long)chunkZ * Integer.MAX_VALUE + (long)chunkX;
                    chunk = chunks.get(chunkKey);
                    if (chunk == null) {
                        throw new CorruptedWorldException(worldName);
                    }
                    chunk.getTileEntities().add(tileEntityCompound);
                }
            }
            if ((extraCompound = LoaderUtils.readCompoundTag(extraTag)) == null) {
                extraCompound = new CompoundTag("", new CompoundMap());
            }
            List mapList = (mapsCompound = LoaderUtils.readCompoundTag(mapsTag)) != null ? (List)mapsCompound.getAsListTag("maps").map(ListTag::getValue).orElse(new ArrayList()) : new ArrayList();
            if (worldVersion == 0) {
                block4: for (SlimeChunk chunk2 : chunks.values()) {
                    for (SlimeChunkSection section : chunk2.getSections()) {
                        if (section == null) continue;
                        worldVersion = (byte)(section.getBlocks() == null ? 4 : 1);
                        break block4;
                    }
                }
            }
            SlimePropertyMap worldPropertyMap = propertyMap;
            Optional<CompoundTag> propertiesTag = extraCompound.getAsCompoundTag("properties");
            if (propertiesTag.isPresent()) {
                worldPropertyMap = SlimePropertyMap.fromCompound(propertiesTag.get());
                worldPropertyMap.merge(propertyMap);
            } else if (propertyMap == null) {
                worldPropertyMap = new SlimePropertyMap();
            }
            return new CraftSlimeWorld(loader, worldName, chunks, extraCompound, mapList, worldVersion, worldPropertyMap, readOnly, !readOnly);
        }
        catch (EOFException ex) {
            throw new CorruptedWorldException(worldName, ex);
        }
    }

    private static int floor(double num) {
        int floor = (int)num;
        return (double)floor == num ? floor : floor - (int)(Double.doubleToRawLongBits(num) >>> 63);
    }

    private static Map<Long, SlimeChunk> readChunks(byte worldVersion, int version, String worldName, int minX, int minZ, int width, int depth, BitSet chunkBitset, byte[] chunkData) throws IOException {
        DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(chunkData));
        HashMap<Long, SlimeChunk> chunkMap = new HashMap<Long, SlimeChunk>();
        for (int z = 0; z < depth; ++z) {
            for (int x = 0; x < width; ++x) {
                int[] biomes;
                CompoundTag heightMaps;
                int bitsetIndex = z * width + x;
                if (!chunkBitset.get(bitsetIndex)) continue;
                if (worldVersion >= 4) {
                    int heightMapsLength = dataStream.readInt();
                    byte[] heightMapsArray = new byte[heightMapsLength];
                    dataStream.read(heightMapsArray);
                    heightMaps = LoaderUtils.readCompoundTag(heightMapsArray);
                    if (heightMaps == null) {
                        heightMaps = new CompoundTag("", new CompoundMap());
                    }
                } else {
                    int[] heightMap = new int[256];
                    for (int i = 0; i < 256; ++i) {
                        heightMap[i] = dataStream.readInt();
                    }
                    CompoundMap map = new CompoundMap();
                    map.put("heightMap", new IntArrayTag("heightMap", heightMap));
                    heightMaps = new CompoundTag("", map);
                }
                if (version == 8 && worldVersion < 4) {
                    dataStream.readInt();
                }
                if (worldVersion >= 4) {
                    int biomesArrayLength = version >= 8 ? dataStream.readInt() : 256;
                    biomes = new int[biomesArrayLength];
                    for (int i = 0; i < biomes.length; ++i) {
                        biomes[i] = dataStream.readInt();
                    }
                } else {
                    byte[] byteBiomes = new byte[256];
                    dataStream.read(byteBiomes);
                    biomes = LoaderUtils.toIntArray(byteBiomes);
                }
                SlimeChunkSection[] sections = LoaderUtils.readChunkSections(dataStream, worldVersion, version);
                chunkMap.put(((long)minZ + (long)z) * Integer.MAX_VALUE + ((long)minX + (long)x), new CraftSlimeChunk(worldName, minX + x, minZ + z, sections, heightMaps, biomes, new ArrayList<CompoundTag>(), new ArrayList<CompoundTag>()));
            }
        }
        return chunkMap;
    }

    private static int[] toIntArray(byte[] buf) {
        ByteBuffer buffer = ByteBuffer.wrap(buf).order(ByteOrder.BIG_ENDIAN);
        int[] ret = new int[buf.length / 4];
        buffer.asIntBuffer().get(ret);
        return ret;
    }

    private static SlimeChunkSection[] readChunkSections(DataInputStream dataStream, byte worldVersion, int version) throws IOException {
        SlimeChunkSection[] chunkSectionArray = new SlimeChunkSection[16];
        byte[] sectionBitmask = new byte[2];
        dataStream.read(sectionBitmask);
        BitSet sectionBitset = BitSet.valueOf(sectionBitmask);
        for (int i = 0; i < 16; ++i) {
            NibbleArray skyLightArray;
            NibbleArray dataArray;
            byte[] blockArray;
            long[] blockStatesArray;
            ListTag<CompoundTag> paletteTag;
            NibbleArray blockLightArray;
            if (!sectionBitset.get(i)) continue;
            if (version < 5 || dataStream.readBoolean()) {
                byte[] blockLightByteArray = new byte[2048];
                dataStream.read(blockLightByteArray);
                blockLightArray = new NibbleArray(blockLightByteArray);
            } else {
                blockLightArray = null;
            }
            if (worldVersion >= 4) {
                int paletteLength = dataStream.readInt();
                ArrayList<CompoundTag> paletteList = new ArrayList<CompoundTag>(paletteLength);
                for (int index = 0; index < paletteLength; ++index) {
                    int tagLength = dataStream.readInt();
                    byte[] serializedTag = new byte[tagLength];
                    dataStream.read(serializedTag);
                    paletteList.add(LoaderUtils.readCompoundTag(serializedTag));
                }
                paletteTag = new ListTag<CompoundTag>("", TagType.TAG_COMPOUND, paletteList);
                int blockStatesArrayLength = dataStream.readInt();
                blockStatesArray = new long[blockStatesArrayLength];
                for (int index = 0; index < blockStatesArrayLength; ++index) {
                    blockStatesArray[index] = dataStream.readLong();
                }
                blockArray = null;
                dataArray = null;
            } else {
                blockArray = new byte[4096];
                dataStream.read(blockArray);
                byte[] dataByteArray = new byte[2048];
                dataStream.read(dataByteArray);
                dataArray = new NibbleArray(dataByteArray);
                paletteTag = null;
                blockStatesArray = null;
            }
            if (version < 5 || dataStream.readBoolean()) {
                byte[] skyLightByteArray = new byte[2048];
                dataStream.read(skyLightByteArray);
                skyLightArray = new NibbleArray(skyLightByteArray);
            } else {
                skyLightArray = null;
            }
            if (version < 4) {
                short hypixelBlocksLength = dataStream.readShort();
                dataStream.skip(hypixelBlocksLength);
            }
            chunkSectionArray[i] = new CraftSlimeChunkSection(blockArray, dataArray, paletteTag, blockStatesArray, blockLightArray, skyLightArray);
        }
        return chunkSectionArray;
    }

    private static CompoundTag readCompoundTag(byte[] serializedCompound) throws IOException {
        if (serializedCompound.length == 0) {
            return null;
        }
        NBTInputStream stream = new NBTInputStream(new ByteArrayInputStream(serializedCompound), 0, ByteOrder.BIG_ENDIAN);
        return (CompoundTag)stream.readTag();
    }
}

