/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.upgrade.v1_14;

import com.grinderwolf.swm.api.world.SlimeChunk;
import com.grinderwolf.swm.api.world.SlimeChunkSection;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ByteTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.IntTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.StringTag;
import com.grinderwolf.swm.nms.CraftSlimeWorld;
import com.grinderwolf.swm.plugin.upgrade.Upgrade;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class v1_14WorldUpgrade
implements Upgrade {
    private static final int[] VILLAGER_XP = new int[]{0, 10, 50, 100, 150};
    private static Map<String, String> oldToNewMap = new HashMap<String, String>();
    private static Map<String, String> newToOldMap = new HashMap<String, String>();

    private static void rename(String oldName, String newName) {
        oldToNewMap.put(oldName, newName);
        newToOldMap.put(newName, oldName);
    }

    @Override
    public void upgrade(CraftSlimeWorld world) {
        for (SlimeChunk chunk : new ArrayList<SlimeChunk>(world.getChunks().values())) {
            for (int sectionIndex = 0; sectionIndex < chunk.getSections().length; ++sectionIndex) {
                SlimeChunkSection section = chunk.getSections()[sectionIndex];
                if (section == null) continue;
                Object palette = section.getPalette().getValue();
                for (int paletteIndex = 0; paletteIndex < palette.size(); ++paletteIndex) {
                    String newName;
                    CompoundTag blockTag = (CompoundTag)palette.get(paletteIndex);
                    String name = blockTag.getStringValue("Name").get();
                    if (name.equals("minecraft:trapped_chest")) {
                        this.updateBlockEntities(chunk, sectionIndex, paletteIndex, "minecraft:chest", "minecraft:trapped_chest");
                    }
                    if ((newName = oldToNewMap.get(name)) == null) continue;
                    blockTag.getValue().put("Name", new StringTag("Name", newName));
                }
            }
            if (chunk.getEntities() == null) continue;
            for (CompoundTag entityTag : chunk.getEntities()) {
                String type;
                switch (type = entityTag.getStringValue("id").get()) {
                    case "minecraft:ocelot": {
                        int catType = entityTag.getIntValue("CatType").orElse(0);
                        if (catType == 0) {
                            Optional<String> owner = entityTag.getStringValue("Owner");
                            Optional<String> ownerId = entityTag.getStringValue("OwnerUUID");
                            if (owner.isPresent() || ownerId.isPresent()) {
                                entityTag.getValue().put("Trusting", new ByteTag("Trusting", 1));
                            }
                            entityTag.getValue().remove("CatType");
                            break;
                        }
                        if (catType <= 0 || catType >= 4) break;
                        entityTag.getValue().put("id", new StringTag("id", "minecraft:cat"));
                        break;
                    }
                    case "minecraft:villager": 
                    case "minecraft:zombie_villager": {
                        Optional<CompoundTag> xp;
                        int profession = entityTag.getIntValue("Profession").orElse(0);
                        int career = entityTag.getIntValue("Career").orElse(0);
                        int careerLevel = entityTag.getIntValue("CareerLevel").orElse(1);
                        Optional<CompoundTag> offersOpt = entityTag.getAsCompoundTag("Offers");
                        if (offersOpt.isPresent() && (careerLevel == 0 || careerLevel == 1)) {
                            int amount = offersOpt.flatMap(offers -> offers.getAsCompoundTag("Recipes")).map(recipes -> recipes.getValue().size()).orElse(0);
                            careerLevel = this.clamp(amount / 2, 1, 5);
                        }
                        if (!(xp = entityTag.getAsCompoundTag("Xp")).isPresent()) {
                            entityTag.getValue().put("Xp", new IntTag("Xp", VILLAGER_XP[this.clamp(careerLevel - 1, 0, VILLAGER_XP.length - 1)]));
                        }
                        entityTag.getValue().remove("Profession");
                        entityTag.getValue().remove("Career");
                        entityTag.getValue().remove("CareerLevel");
                        CompoundMap dataMap = new CompoundMap();
                        dataMap.put("type", new StringTag("type", "minecraft:plains"));
                        dataMap.put("profession", new StringTag("profession", this.getVillagerProfession(profession, career)));
                        dataMap.put("level", new IntTag("level", careerLevel));
                        entityTag.getValue().put("VillagerData", new CompoundTag("VillagerData", dataMap));
                        break;
                    }
                    case "minecraft:banner": {
                        Optional<String> customName = entityTag.getStringValue("CustomName");
                        if (!customName.isPresent()) break;
                        String newName = customName.get().replace("\"translate\":\"block.minecraft.illager_banner\"", "\"translate\":\"block.minecraft.ominous_banner\"");
                        entityTag.getValue().put("CustomName", new StringTag("CustomName", newName));
                    }
                }
            }
        }
    }

    private int clamp(int i, int i1, int i2) {
        return i < i1 ? i1 : (i > i2 ? i2 : i);
    }

    private String getVillagerProfession(int profession, int career) {
        return profession == 0 ? (career == 2 ? "minecraft:fisherman" : (career == 3 ? "minecraft:shepherd" : (career == 4 ? "minecraft:fletcher" : "minecraft:farmer"))) : (profession == 1 ? (career == 2 ? "minecraft:cartographer" : "minecraft:librarian") : (profession == 2 ? "minecraft:cleric" : (profession == 3 ? (career == 2 ? "minecraft:weaponsmith" : (career == 3 ? "minecraft:toolsmith" : "minecraft:armorer")) : (profession == 4 ? (career == 2 ? "minecraft:leatherworker" : "minecraft:butcher") : (profession == 5 ? "minecraft:nitwit" : "minecraft:none")))));
    }

    @Override
    public void downgrade(CraftSlimeWorld world) {
        for (SlimeChunk chunk : new ArrayList<SlimeChunk>(world.getChunks().values())) {
            for (int sectionIndex = 0; sectionIndex < chunk.getSections().length; ++sectionIndex) {
                SlimeChunkSection section = chunk.getSections()[sectionIndex];
                if (section == null) continue;
                Object palette = section.getPalette().getValue();
                for (int paletteIndex = 0; paletteIndex < palette.size(); ++paletteIndex) {
                    String newName;
                    CompoundTag blockTag = (CompoundTag)palette.get(paletteIndex);
                    String name = blockTag.getStringValue("Name").get();
                    if (name.equals("minecraft:trapped_chest")) {
                        this.updateBlockEntities(chunk, sectionIndex, paletteIndex, "minecraft:trapped_chest", "minecraft:chest");
                    }
                    if ((newName = newToOldMap.get(name)) == null) continue;
                    blockTag.getValue().put("Name", new StringTag("Name", newName));
                }
            }
            if (chunk.getEntities() == null) continue;
            for (CompoundTag entityTag : chunk.getEntities()) {
                String type;
                switch (type = entityTag.getStringValue("id").get()) {
                    case "minecraft:cat": {
                        entityTag.getValue().put("id", new StringTag("id", "minecraft:ocelot"));
                        break;
                    }
                    case "minecraft:villager": 
                    case "minecraft:zombie_villager": {
                        CompoundTag dataTag = entityTag.getAsCompoundTag("VillagerData").get();
                        String profession = dataTag.getStringValue("profession").get();
                        int[] professionData = this.getVillagerProfession(profession);
                        entityTag.getValue().remove("VillagerData");
                        entityTag.getValue().put("Profession", new IntTag("Profession", professionData[0]));
                        entityTag.getValue().put("Career", new IntTag("Career", professionData[1]));
                        entityTag.getValue().put("CareerLevel", new IntTag("Career", 1));
                        break;
                    }
                    case "minecraft:banner": {
                        Optional<String> customName = entityTag.getStringValue("CustomName");
                        if (!customName.isPresent()) break;
                        String newName = customName.get().replace("\"translate\":\"block.minecraft.ominous_banner\"", "\"translate\":\"block.minecraft.illager_banner\"");
                        entityTag.getValue().put("CustomName", new StringTag("CustomName", newName));
                    }
                }
            }
        }
    }

    private int[] getVillagerProfession(String profession) {
        switch (profession) {
            case "minecraft:farmer": {
                return new int[]{0, 1};
            }
            case "minecraft:fisherman": {
                return new int[]{0, 2};
            }
            case "minecraft:shepherd": {
                return new int[]{0, 3};
            }
            case "minecraft:fletcher": {
                return new int[]{0, 4};
            }
            case "minecraft:librarian": {
                return new int[]{1, 1};
            }
            case "minecraft:cartographer": {
                return new int[]{1, 2};
            }
            case "minecraft:cleric": {
                return new int[]{2, 1};
            }
            case "minecraft:armorer": {
                return new int[]{3, 1};
            }
            case "minecraft:weaponsmith": {
                return new int[]{3, 2};
            }
            case "minecraft:toolsmith": {
                return new int[]{3, 3};
            }
            case "minecraft:butcher": {
                return new int[]{4, 1};
            }
            case "minecraft:leatherworker": {
                return new int[]{4, 2};
            }
            case "minecraft:nitwit": {
                return new int[]{5, 1};
            }
        }
        return new int[]{0, 0};
    }

    private void updateBlockEntities(SlimeChunk chunk, int sectionIndex, int paletteIndex, String oldName, String newName) {
        if (chunk.getTileEntities() != null) {
            SlimeChunkSection section = chunk.getSections()[sectionIndex];
            long[] blockData = section.getBlockStates();
            int bitsPerBlock = Math.max(4, blockData.length * 64 / 4096);
            long maxEntryValue = (1L << bitsPerBlock) - 1L;
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    block2: for (int x = 0; x < 16; ++x) {
                        int val;
                        int arrayIndex = y << 8 | z << 4 | x;
                        int bitIndex = arrayIndex * bitsPerBlock;
                        int startIndex = bitIndex / 64;
                        int endIndex = ((arrayIndex + 1) * bitsPerBlock - 1) / 64;
                        int startBitSubIndex = bitIndex % 64;
                        if (startIndex == endIndex) {
                            val = (int)(blockData[startIndex] >>> startBitSubIndex & maxEntryValue);
                        } else {
                            int endBitSubIndex = 64 - startBitSubIndex;
                            val = (int)((blockData[startIndex] >>> startBitSubIndex | blockData[endIndex] << endBitSubIndex) & maxEntryValue);
                        }
                        if (val != paletteIndex) continue;
                        int blockX = x + chunk.getX() * 16;
                        int blockY = y + sectionIndex * 16;
                        int blockZ = z + chunk.getZ() * 16;
                        for (CompoundTag tileEntityTag : chunk.getTileEntities()) {
                            int tileX = tileEntityTag.getIntValue("x").get();
                            int tileY = tileEntityTag.getIntValue("y").get();
                            int tileZ = tileEntityTag.getIntValue("z").get();
                            if (tileX != blockX || tileY != blockY || tileZ != blockZ) continue;
                            String type = tileEntityTag.getStringValue("id").get();
                            if (!type.equals(oldName)) {
                                throw new IllegalStateException("Expected block entity to be " + oldName + ", not " + type);
                            }
                            tileEntityTag.getValue().put("id", new StringTag("id", newName));
                            continue block2;
                        }
                    }
                }
            }
        }
    }

    static {
        v1_14WorldUpgrade.rename("minecraft:tube_coral_fan", "minecraft:tube_coral_wall_fan");
        v1_14WorldUpgrade.rename("minecraft:brain_coral_fan", "minecraft:brain_coral_wall_fan");
        v1_14WorldUpgrade.rename("minecraft:bubble_coral_fan", "minecraft:bubble_coral_wall_fan");
        v1_14WorldUpgrade.rename("minecraft:fire_coral_fan", "minecraft:fire_coral_wall_fan");
        v1_14WorldUpgrade.rename("minecraft:horn_coral_fan", "minecraft:horn_coral_wall_fan");
        v1_14WorldUpgrade.rename("minecraft:stone_slab", "minecraft:smooth_stone_slab");
        v1_14WorldUpgrade.rename("minecraft:sign", "minecraft:oak_sign");
        v1_14WorldUpgrade.rename("minecraft:wall_sign", "minecraft:oak_wall_sign");
    }
}

