/*
 * Decompiled with CFR 0.152.
 */
package io.github.tanguygab.bw1058expansion;

import com.andrei1058.bedwars.api.BedWars;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.language.Language;
import com.andrei1058.bedwars.api.party.Party;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Taskable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public final class BW1058Expansion
extends PlaceholderExpansion
implements Taskable {
    private BedWars api;
    private final List<String> placeholders;
    private final SimpleDateFormat nextEventFormat = new SimpleDateFormat("mm:ss");

    public BW1058Expansion() {
        this.placeholders = Stream.of("team_letter", "team_color", "team_status", "team_players_amount", "team_players", "team_letter_<team>", "team_color_<team>", "team_status_<team>", "team_players_amount_<team>", "team_players_<team>", "arena_nextevent", "arena_nextevent_name", "arena_nextevent_time", "arena_name", "arena_display_name", "arena_group", "arena_world", "arena_status_plocale", "arena_status", "player_kills", "player_kills_final", "player_kills_total", "player_deaths", "player_deaths_final", "player_deaths_total", "player_beds", "players", "players_amount", "party_has", "party_members", "party_members_amount", "party_in_yours_<player>", "party_in_his_<player>", "party_is_owner").map(p -> "%bw1058plus_" + p + "%").collect(Collectors.toList());
    }

    @Nonnull
    public String getIdentifier() {
        return "bw1058plus";
    }

    @Nonnull
    public String getAuthor() {
        return "Tanguygab";
    }

    @Nonnull
    public String getVersion() {
        return "1.2.2";
    }

    public String getRequiredPlugin() {
        return "BedWars1058";
    }

    @Nonnull
    public List<String> getPlaceholders() {
        return this.placeholders;
    }

    public void start() {
        RegisteredServiceProvider r = Bukkit.getServicesManager().getRegistration(BedWars.class);
        if (r != null) {
            this.api = (BedWars)r.getProvider();
        }
    }

    public void stop() {
    }

    public String onRequest(OfflinePlayer player, @Nonnull String params) {
        Object team;
        if (player == null) {
            return "";
        }
        Player p = player.getPlayer();
        if (p == null) {
            return "";
        }
        Party party = this.api.getPartyUtil();
        if (params.equalsIgnoreCase("party_has")) {
            return String.valueOf(party.hasParty(p));
        }
        if (params.startsWith("party_members")) {
            StringBuilder output = new StringBuilder();
            ArrayList list = new ArrayList(party.getMembers(p));
            if (params.equalsIgnoreCase("party_members_amount")) {
                output = new StringBuilder(String.valueOf(list.size()));
            } else if (params.equalsIgnoreCase("party_members")) {
                for (Player pl : list) {
                    output.append(pl.getName());
                    if (list.indexOf(pl) == list.size() - 1) continue;
                    output.append(", ");
                }
            }
            return output.toString();
        }
        if (params.startsWith("party_in_yours_")) {
            Player p2 = Bukkit.getServer().getPlayer(params.replace("party_in_yours_", ""));
            if (p2 == null) {
                return "false";
            }
            return String.valueOf(party.isMember(p, p2));
        }
        if (params.startsWith("party_in_his_")) {
            Player p2 = Bukkit.getServer().getPlayer(params.replace("party_in_his_", ""));
            if (p2 == null) {
                return "false";
            }
            return String.valueOf(party.isMember(p2, p));
        }
        if (params.startsWith("party_is_owner")) {
            if (params.equalsIgnoreCase("party_is_owner")) {
                return String.valueOf(party.isOwner(p));
            }
            if (params.startsWith("party_is_owner_")) {
                Player p2 = Bukkit.getServer().getPlayer(params.replace("party_is_owner_", ""));
                if (p2 == null) {
                    return "false";
                }
                return String.valueOf(party.isOwner(p2));
            }
        }
        Language lang = this.api.getPlayerLanguage(p);
        if (params.startsWith("lang")) {
            return lang.getLangName();
        }
        IArena arena = this.api.getArenaUtil().getArenaByPlayer(p);
        if (arena == null) {
            return "";
        }
        if (params.startsWith("team_status") && (team = params.equalsIgnoreCase("team_status") ? arena.getTeam(p) : arena.getTeam(params.replace("team_status_", ""))) != null) {
            return !team.isBedDestroyed() ? lang.getString("format-sb-team-alive") : (!team.getMembers().isEmpty() ? String.valueOf(team.getMembers().size()) : lang.getString("format-sb-team-eliminated"));
        }
        if (params.startsWith("team_color") && (team = params.equalsIgnoreCase("team_color") ? arena.getTeam(p) : arena.getTeam(params.replace("team_color_", ""))) != null) {
            return team.getColor().chat().toString();
        }
        if (params.startsWith("team_letter") && (team = params.equalsIgnoreCase("team_letter") ? arena.getTeam(p) : arena.getTeam(params.replace("team_letter_", ""))) != null) {
            return team.getName().substring(0, 1).toUpperCase();
        }
        if (params.startsWith("team_players_amount") && (team = params.equalsIgnoreCase("team_players_amount") ? arena.getTeam(p) : arena.getTeam(params.replace("team_players_amount_", ""))) != null) {
            return String.valueOf(team.getMembers().size());
        }
        if (params.startsWith("team_players") && (team = params.equalsIgnoreCase("team_players") ? arena.getTeam(p) : arena.getTeam(params.replace("team_players_", ""))) != null) {
            StringBuilder output = new StringBuilder();
            ArrayList list = new ArrayList(team.getMembers());
            for (Player pl : list) {
                output.append(pl.getName());
                if (list.indexOf(pl) == list.size() - 1) continue;
                output.append(", ");
            }
            return output.toString();
        }
        switch (params) {
            case "arena_nextevent_name": {
                return arena.getNextEvent().toString().toLowerCase().replace("_", " ");
            }
            case "arena_nextevent_time": {
                return String.valueOf(this.getNextEventTime(arena));
            }
            case "arena_nextevent_time_formatted": {
                return this.nextEventFormat.format(new Date((long)this.getNextEventTime(arena) * 1000L));
            }
            case "arena_name": {
                return arena.getArenaName();
            }
            case "arena_display_name": {
                return arena.getDisplayName();
            }
            case "arena_group": {
                return arena.getGroup();
            }
            case "arena_world": {
                return arena.getWorldName();
            }
            case "arena_status_plocale": {
                return arena.getDisplayStatus(lang);
            }
            case "arena_status": {
                return arena.getDisplayStatus(this.api.getDefaultLang());
            }
            case "player_kills": {
                return String.valueOf(arena.getPlayerKills(p, false));
            }
            case "player_kills_total": {
                return String.valueOf(arena.getPlayerKills(p, true) + arena.getPlayerKills(p, false));
            }
            case "player_kills_final": {
                return String.valueOf(arena.getPlayerKills(p, true));
            }
            case "player_deaths": {
                return String.valueOf(arena.getPlayerDeaths(p, false));
            }
            case "player_deaths_total": {
                return String.valueOf(arena.getPlayerDeaths(p, true) + arena.getPlayerDeaths(p, false));
            }
            case "player_deaths_final": {
                return String.valueOf(arena.getPlayerDeaths(p, true));
            }
            case "player_beds": {
                return String.valueOf(arena.getPlayerBedsDestroyed(p));
            }
        }
        if (params.startsWith("players")) {
            StringBuilder output = new StringBuilder();
            ArrayList list = new ArrayList(arena.getPlayers());
            if (params.equalsIgnoreCase("players_amount")) {
                output = new StringBuilder(String.valueOf(list.size()));
            } else if (params.equalsIgnoreCase("players")) {
                for (Player pl : list) {
                    output.append(pl.getName());
                    if (list.indexOf(pl) == list.size() - 1) continue;
                    output.append(", ");
                }
            }
            return output.toString();
        }
        return "";
    }

    private int getNextEventTime(IArena arena) {
        switch (arena.getNextEvent()) {
            case EMERALD_GENERATOR_TIER_II: 
            case EMERALD_GENERATOR_TIER_III: {
                return arena.getUpgradeEmeraldsCount();
            }
            case DIAMOND_GENERATOR_TIER_II: 
            case DIAMOND_GENERATOR_TIER_III: {
                return arena.getUpgradeDiamondsCount();
            }
            case BEDS_DESTROY: {
                return arena.getPlayingTask().getBedsDestroyCountdown();
            }
            case ENDER_DRAGON: {
                return arena.getPlayingTask().getDragonSpawnCountdown();
            }
            case GAME_END: {
                return arena.getPlayingTask().getGameEndCountdown();
            }
        }
        return 0;
    }
}

