/*
 * Decompiled with CFR 0.152.
 */
package me.zuyte.leavedelay;

import com.andrei1058.bedwars.api.BedWars;
import com.andrei1058.bedwars.api.configuration.ConfigManager;
import com.andrei1058.bedwars.api.language.Language;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.zuyte.leavedelay.commands.LeaveDelayCommand;
import me.zuyte.leavedelay.events.InventoryEvents;
import me.zuyte.leavedelay.events.ItemEvents;
import me.zuyte.leavedelay.events.PlayerEvents;
import me.zuyte.leavedelay.utils.ColorUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin {
    private static ConfigManager cfg;
    private static ConfigManager msg;
    private static BedWars bw;
    private static Main instance;
    public static Boolean useLang;
    private final Map<String, Boolean> click = new HashMap<String, Boolean>();

    public void onEnable() {
        if (Bukkit.getPluginManager().getPlugin("BedWars1058") == null) {
            this.getLogger().severe("BedWars1058 was not found. Disabling...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        instance = this;
        useLang = false;
        bw = (BedWars)Bukkit.getServicesManager().getRegistration(BedWars.class).getProvider();
        cfg = new ConfigManager((Plugin)this, "config", "plugins/BedWars1058/Addons/Leave-Delay");
        msg = new ConfigManager((Plugin)this, "messages", "plugins/BedWars1058/Addons/Leave-Delay");
        this.getServer().getPluginManager().registerEvents((Listener)new ItemEvents(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEvents(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryEvents(), (Plugin)this);
        this.getCommand("leavedelay").setExecutor((CommandExecutor)new LeaveDelayCommand());
        Main.setupConfigs();
        if (Main.getCfg().getBoolean(".settings.use-lang")) {
            this.getLogger().warning("Using Bedwars1058's language system");
            useLang = true;
            Main.setupLang();
        }
        this.getLogger().info("Plugin enabled successfully!");
    }

    public static ConfigManager getCfg() {
        return cfg;
    }

    public static ConfigManager getMsg() {
        return msg;
    }

    public static BedWars getBedWars() {
        return bw;
    }

    public static Main getInstance() {
        return instance;
    }

    public Boolean existClick(String s) {
        return this.click.containsKey(s);
    }

    public void setClick(String s) {
        this.click.put(s, true);
    }

    public void removeClick(String s) {
        this.click.remove(s);
    }

    private static void setupConfigs() {
        YamlConfiguration cfgYml = Main.getCfg().getYml();
        cfgYml.options().header("Bedwars1058-LeaveDelay Addon for Bedwars1058 by Zuyte!\nDocumentation: https://zuyte.netlify.app/docs/Welcome");
        cfgYml.addDefault(".item.material", (Object)Main.getBedWars().getForCurrentVersion("BED", "BED", "RED_BED"));
        cfgYml.addDefault(".item.slot", (Object)8);
        cfgYml.addDefault(".item.name", (Object)"&c&lReturn to Lobby &7(Right Click)");
        cfgYml.addDefault(".item.lore", Arrays.asList("&fRight-Click to leave arena!"));
        cfgYml.addDefault(".settings.delay", (Object)3);
        cfgYml.options().copyDefaults(true);
        Main.getCfg().save();
        YamlConfiguration msgYml = Main.getMsg().getYml();
        msgYml.options().header("Bedwars1058-LeaveDelay Addon for Bedwars1058 by Zuyte!\nDocumentation: https://zuyte.netlify.app/docs/Welcome");
        msgYml.addDefault(".start", (Object)"&a&lTeleporting you to the lobby in 3 seconds... Right-click again to cancel the teleport!");
        msgYml.addDefault(".cancel", (Object)"&c&lTeleport cancelled!");
        msgYml.options().copyDefaults(true);
        Main.getMsg().save();
    }

    private static void setupLang() {
        for (Language language : Language.getLanguages()) {
            if (!language.exists(".addons.leavedelay.item.name")) {
                language.set(".addons.leavedelay.item.name", (Object)"&c&lReturn to Lobby &7(Right Click)");
            }
            if (!language.exists(".addons.leavedelay.item.lore")) {
                language.set(".addons.leavedelay.item.lore", Arrays.asList("&fRight-Click to leave arena!"));
            }
            if (!language.exists(".addons.leavedelay.messages.start")) {
                language.set(".addons.leavedelay.messages.start", (Object)"&a&lTeleporting you to the lobby in {delay} seconds... Right-click again to cancel the teleport!");
            }
            if (language.exists(".addons.leavedelay.messages.cancel")) continue;
            language.set(".addons.leavedelay.messages.cancel", (Object)"&c&lTeleport cancelled!");
        }
    }

    public static void bedItem(Player p) {
        Material BedMaterial = null;
        try {
            BedMaterial = Material.getMaterial((String)Main.getCfg().getYml().getString(".item.material"));
        }
        catch (Exception ex) {
            Main.getInstance().getLogger().severe("An error occurred while getting CFG_ITEM_MATERIAL from config.yml, Material name might be invalid please check again!");
            ex.printStackTrace();
            return;
        }
        ItemStack BedItem = new ItemStack(BedMaterial, 1);
        ItemMeta BedMeta = BedItem.getItemMeta();
        try {
            BedMeta.setDisplayName(ColorUtil.getMsg(Main.getCfg().getString(".item.name")));
        }
        catch (Exception ex) {
            Main.getInstance().getLogger().severe("An error occurred while getting CFG_ITEM_NAME from config.yml");
            ex.printStackTrace();
            return;
        }
        try {
            BedMeta.setLore(Main.getInstance().colorizeList(Main.getCfg().getYml().getStringList(".item.lore")));
        }
        catch (Exception ex) {
            Main.getInstance().getLogger().severe("An error occurred while getting CFG_ITEM_LORE from config.yml");
            ex.printStackTrace();
            return;
        }
        BedMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        BedItem.setItemMeta(BedMeta);
        ItemStack BedItem1 = Main.getBedWars().getVersionSupport().addCustomData(BedItem, "BWLEAVE-DELAY");
        try {
            p.getInventory().setItem(Main.getCfg().getInt(".item.slot"), BedItem1);
        }
        catch (Exception ex) {
            Main.getInstance().getLogger().severe("An error occurred while getting CFG_ITEM_SLOT from config.yml");
            ex.printStackTrace();
            return;
        }
    }

    public List<String> colorizeList(List<String> input) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            for (String line : input) {
                ret.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
        }
        catch (Exception ex) {
            Main.getInstance().getLogger().severe("An error occurred while getting CFG_ITEM_LORE from config.yml");
            ex.printStackTrace();
            return null;
        }
        return ret;
    }
}

