/*
 * Decompiled with CFR 0.152.
 */
package me.leoo.bedwars.mapselector;

import com.andrei1058.bedwars.BedWars;
import com.andrei1058.bedwars.proxy.BedWarsProxy;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import me.leoo.bedwars.mapselector.commands.FirstGuiCommand;
import me.leoo.bedwars.mapselector.commands.MainCommand;
import me.leoo.bedwars.mapselector.commands.SecondGuiCommand;
import me.leoo.bedwars.mapselector.configuration.CacheConfig;
import me.leoo.bedwars.mapselector.configuration.ConfigManager;
import me.leoo.bedwars.mapselector.configuration.MainConfig;
import me.leoo.bedwars.mapselector.database.Database;
import me.leoo.bedwars.mapselector.listeners.JoinListener;
import me.leoo.bedwars.mapselector.listeners.SelectorMenuListeners;
import me.leoo.bedwars.mapselector.listeners.SelectorMenuProxyListeners;
import me.leoo.bedwars.mapselector.utils.BedwarsMode;
import me.leoo.bedwars.mapselector.utils.PlaceholdersUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MapSelector
extends JavaPlugin {
    private static MapSelector plugin;
    private ConfigManager mainConfig;
    private ConfigManager cacheConfig;
    private Database ddatabase;
    private BedwarsMode bedwarsMode;

    public void onEnable() {
        plugin = this;
        if (Bukkit.getPluginManager().getPlugin("BedWars1058") != null) {
            this.bedwarsMode = BedwarsMode.BEDWARS;
            this.registerEvents(new SelectorMenuListeners());
            this.getLogger().info("Hooked into BedWars1058");
        }
        if (Bukkit.getPluginManager().getPlugin("BedWarsProxy") != null) {
            this.bedwarsMode = BedwarsMode.PROXY;
            this.registerEvents(new SelectorMenuProxyListeners());
            this.getLogger().info("Hooked into BedWarsProxy");
        }
        if (this.bedwarsMode == null) {
            this.getLogger().info("Bedwars1058/BedwarsProxy not found. Disabling...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
        this.mainConfig = new MainConfig((Plugin)this, "config", "plugins/" + this.bedwarsMode.getName() + "/Addons/MapSelector");
        this.cacheConfig = new CacheConfig((Plugin)this, "cache", "plugins/" + this.bedwarsMode.getName() + "/Addons/MapSelector");
        this.connectDatabase();
        if (Bukkit.getPluginManager().isPluginEnabled((Plugin)this)) {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                new PlaceholdersUtil().register();
            }
            this.registerEvents(new JoinListener());
            try {
                Field field = Bukkit.getServer().getClass().getDeclaredField("commandMap");
                field.setAccessible(true);
                CommandMap commandMap = (CommandMap)field.get(Bukkit.getServer());
                commandMap.register("bedwarsmenu", (Command)new FirstGuiCommand("bedwarsmenu"));
                commandMap.register("bedwarsmap", (Command)new SecondGuiCommand("bedwarsmap"));
                commandMap.register("bedwarsselector", (Command)new MainCommand("bedwarsselector"));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
            this.getLogger().info(ChatColor.translateAlternateColorCodes((char)'&', (String)("&a" + this.getDescription().getName() + " plugin by itz_leoo has been successfully enabled.")));
        }
    }

    public void onDisable() {
        if (this.ddatabase != null) {
            this.ddatabase.close();
        }
        MapSelector.getPlugin().getLogger().info(ChatColor.translateAlternateColorCodes((char)'&', (String)("&c" + this.getDescription().getName() + " plugin by itz_leoo has been successfully disabled.")));
    }

    public void debug(String string) {
        if (this.mainConfig == null) {
            return;
        }
        if (this.mainConfig.getBoolean("map-selector.debug")) {
            MapSelector.getPlugin().getLogger().info(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
        }
    }

    public void connectDatabase() {
        block13: {
            if (this.ddatabase == null) {
                try {
                    String storage = this.mainConfig.getString("map-selector.storage");
                    if (storage == null || storage.equalsIgnoreCase("sqlite")) {
                        this.mainConfig.set("map-selector.storage", "SQLite");
                        File folder = new File(this.bedwarsMode.equals((Object)BedwarsMode.BEDWARS) ? BedWars.plugin.getDataFolder() + "/Cache" : BedWarsProxy.getPlugin().getDataFolder() + "/Cache");
                        File file = new File(folder, "database.db");
                        if (!folder.exists()) {
                            MapSelector.getPlugin().getLogger().info("Creating " + folder.getPath());
                            if (!folder.mkdirs()) {
                                MapSelector.getPlugin().getLogger().severe("Could not create " + folder.getPath());
                            }
                        }
                        if (!file.exists()) {
                            plugin.getLogger().info("Creating " + file.getPath());
                            try {
                                if (!file.createNewFile()) {
                                    plugin.getLogger().severe("Could not create " + file.getPath());
                                    return;
                                }
                            }
                            catch (IOException exception) {
                                exception.printStackTrace();
                            }
                        }
                        this.ddatabase = new Database(file.getAbsolutePath());
                        break block13;
                    }
                    this.mainConfig.set("map-selector.storage", "MySQL");
                    if (this.bedwarsMode.equals((Object)BedwarsMode.BEDWARS)) {
                        this.ddatabase = new Database(BedWars.config.getYml().getString("database.host"), BedWars.config.getYml().getInt("database.port"), BedWars.config.getYml().getString("database.database"), BedWars.config.getYml().getString("database.user"), BedWars.config.getYml().getString("database.pass"), BedWars.config.getYml().getBoolean("database.ssl"));
                    } else if (this.bedwarsMode.equals((Object)BedwarsMode.PROXY)) {
                        this.ddatabase = new Database(BedWarsProxy.config.getYml().getString("database.host"), BedWarsProxy.config.getYml().getInt("database.port"), BedWarsProxy.config.getYml().getString("database.database"), BedWarsProxy.config.getYml().getString("database.user"), BedWarsProxy.config.getYml().getString("database.pass"), BedWarsProxy.config.getYml().getBoolean("database.ssl"));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    MapSelector.getPlugin().getLogger().info("Unavailable database connection");
                    Bukkit.getPluginManager().disablePlugin((Plugin)MapSelector.getPlugin());
                }
            }
        }
    }

    public Database getMapSelectorDatabase() {
        if (this.ddatabase == null) {
            MapSelector.getPlugin().getLogger().info("Database connection not found. Reconnecting...");
            this.connectDatabase();
        }
        return this.ddatabase;
    }

    private void registerEvents(Listener ... listeners) {
        Arrays.asList(listeners).forEach(listener -> Bukkit.getPluginManager().registerEvents(listener, (Plugin)plugin));
    }

    public ConfigManager getMainConfig() {
        return this.mainConfig;
    }

    public ConfigManager getCacheConfig() {
        return this.cacheConfig;
    }

    public Database getDdatabase() {
        return this.ddatabase;
    }

    public BedwarsMode getBedwarsMode() {
        return this.bedwarsMode;
    }

    public static MapSelector getPlugin() {
        return plugin;
    }
}

