/*
 * Decompiled with CFR 0.152.
 */
package me.leoo.bedwars.mapselector.configuration;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import me.leoo.bedwars.mapselector.MapSelector;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigManager {
    private YamlConfiguration yml;
    private File config;
    private String name;

    public ConfigManager(Plugin plugin, String name, String dir) {
        File folder = new File(dir);
        if (!folder.exists()) {
            plugin.getLogger().log(Level.INFO, "Creating {0}", folder.getPath());
            if (!folder.mkdirs()) {
                plugin.getLogger().log(Level.SEVERE, "Could not create {0}", folder.getPath());
                return;
            }
        }
        if (!folder.exists() && !folder.mkdirs()) {
            plugin.getLogger().log(Level.SEVERE, "Could not create {0}", folder.getPath());
        } else {
            this.config = new File(dir, name + ".yml");
            if (!this.config.exists()) {
                plugin.getLogger().log(Level.INFO, "Creating {0}", this.config.getPath());
                try {
                    if (!this.config.createNewFile()) {
                        plugin.getLogger().log(Level.SEVERE, "Could not create {0}", this.config.getPath());
                        return;
                    }
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
            this.yml = YamlConfiguration.loadConfiguration((File)this.config);
            this.yml.options().copyDefaults(true);
            this.name = name;
        }
    }

    public void reload() {
        this.yml = YamlConfiguration.loadConfiguration((File)this.config);
    }

    public void save() {
        try {
            this.yml.save(this.config);
        }
        catch (IOException var2) {
            var2.printStackTrace();
        }
    }

    public boolean getBoolean(String path) {
        return this.yml.getBoolean(path);
    }

    public int getInt(String path) {
        return this.yml.getInt(path);
    }

    public String getString(String path) {
        if (this.yml.getString(path) == null) {
            MapSelector.getPlugin().getLogger().info("String " + path + " not found in " + this.name + ".yml");
            return "MissingString";
        }
        return PlaceholderAPI.setPlaceholders(null, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.yml.getString(path)));
    }

    public List<String> getList(String path) {
        return this.yml.getStringList(path).stream().map(s -> PlaceholderAPI.setPlaceholders(null, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)s))).collect(Collectors.toList());
    }

    public void set(String path, Object object) {
        this.getYml().set(path, object);
        this.save();
    }

    public YamlConfiguration getYml() {
        return this.yml;
    }

    public File getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }
}

