/*
 * Decompiled with CFR 0.152.
 */
package me.leoo.bedwars.mapselector.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.leoo.bedwars.mapselector.MapSelector;
import org.jetbrains.annotations.NotNull;

public class Database {
    private Connection connection;

    public Database(String host, int port, String name, String username, String password, boolean ssl) throws Exception {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl("jdbc:mysql://" + host + ":" + port + "/" + name);
        hikariConfig.setPoolName("[" + MapSelector.getPlugin().getDescription().getName() + "-MySQL]");
        hikariConfig.setMaximumPoolSize(10);
        hikariConfig.setMaxLifetime(1800000L);
        hikariConfig.setUsername(username);
        hikariConfig.setPassword(password);
        hikariConfig.addDataSourceProperty("useSSL", String.valueOf(ssl));
        hikariConfig.addDataSourceProperty("autoReconnect", "true");
        hikariConfig.addDataSourceProperty("verifyServerCertificate", String.valueOf(false));
        hikariConfig.addDataSourceProperty("characterEncoding", "utf8");
        hikariConfig.addDataSourceProperty("encoding", "UTF-8");
        hikariConfig.addDataSourceProperty("useUnicode", "true");
        hikariConfig.addDataSourceProperty("rewriteBatchedStatements", "true");
        hikariConfig.addDataSourceProperty("jdbcCompliantTruncation", "false");
        hikariConfig.addDataSourceProperty("cachePrepStmts", "true");
        hikariConfig.addDataSourceProperty("prepStmtCacheSize", "275");
        hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        hikariConfig.addDataSourceProperty("socketTimeout", String.valueOf(TimeUnit.SECONDS.toMillis(30L)));
        this.connection = new HikariDataSource(hikariConfig).getConnection();
        MapSelector.getPlugin().getLogger().info("Connected to the database");
        this.createTables();
    }

    public Database(String file) throws Exception {
        Class.forName("org.sqlite.JDBC");
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + file);
        MapSelector.getPlugin().getLogger().info("Connected to the database");
        this.createTables();
    }

    public void close() {
        if (this.connection == null) {
            return;
        }
        try {
            this.getConnection().close();
            MapSelector.getPlugin().getLogger().info("Closed the database connection");
        }
        catch (Exception e) {
            e.printStackTrace();
            MapSelector.getPlugin().getLogger().info("Error while trying to close the database connection");
        }
        this.connection = null;
    }

    @NotNull
    private Connection getConnection() {
        if (this.connection == null) {
            MapSelector.getPlugin().connectDatabase();
        }
        return this.connection;
    }

    public void createTables() throws SQLException {
        this.getConnection().createStatement().execute("CREATE TABLE IF NOT EXISTS map_selector (uuid VARCHAR(50), uses INT(10))");
    }

    public boolean isRegistered(UUID uuid) {
        boolean bl;
        block8: {
            PreparedStatement preparedStatement = this.getConnection().prepareStatement("SELECT uuid FROM map_selector WHERE uuid = ?");
            try {
                preparedStatement.setString(1, String.valueOf(uuid));
                bl = preparedStatement.executeQuery().next();
                if (preparedStatement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            preparedStatement.close();
        }
        return bl;
    }

    public void register(UUID uuid) {
        try (PreparedStatement preparedStatement = this.getConnection().prepareStatement("INSERT INTO map_selector (uuid, uses) VALUES(?, ?)");){
            preparedStatement.setString(1, String.valueOf(uuid));
            preparedStatement.setInt(2, 0);
            preparedStatement.executeUpdate();
            MapSelector.getPlugin().debug("Registered a new player with the uuid " + uuid);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void checkStored(UUID uuid) {
        if (!this.isRegistered(uuid)) {
            this.register(uuid);
        }
    }

    public void setPlayerUses(UUID uuid, int uses) {
        try (PreparedStatement preparedStatement = this.getConnection().prepareStatement("UPDATE map_selector SET uses = ? WHERE uuid = ?");){
            preparedStatement.setInt(1, uses);
            preparedStatement.setString(2, String.valueOf(uuid));
            preparedStatement.executeUpdate();
            MapSelector.getPlugin().debug("Set player's with uuid " + uuid + " uses to " + uses);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setAllPlayersUses(int uses) {
        try (PreparedStatement preparedStatement = this.getConnection().prepareStatement("UPDATE map_selector SET uses = ?");){
            preparedStatement.setInt(1, uses);
            preparedStatement.executeUpdate();
            MapSelector.getPlugin().debug("Set all players uses to " + uses);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPlayerUses(UUID uuid) {
        try (PreparedStatement preparedStatement = this.getConnection().prepareStatement("SELECT uses FROM map_selector WHERE uuid = ?");){
            preparedStatement.setString(1, String.valueOf(uuid));
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) return 0;
            int n = resultSet.getInt("uses");
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }
}

