/*
 * Decompiled with CFR 0.152.
 */
package me.leoo.bedwars.mapselector.database;

import com.andrei1058.bedwars.api.arena.GameState;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.arena.Arena;
import com.andrei1058.bedwars.proxy.api.ArenaStatus;
import com.andrei1058.bedwars.proxy.api.CachedArena;
import com.andrei1058.bedwars.proxy.arenamanager.ArenaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.leoo.bedwars.mapselector.MapSelector;
import org.bukkit.entity.Player;

public class Yaml {
    public static void storePlayer(Player player) {
        MapSelector.getPlugin().getCacheConfig().set(player.getUniqueId() + ".favorite-maps", Collections.emptyList());
        MapSelector.getPlugin().getCacheConfig().set(player.getUniqueId() + ".per-map-times-joined", Collections.emptyList());
    }

    public static boolean isStoredPlayer(Player player) {
        return MapSelector.getPlugin().getCacheConfig().getYml().contains(String.valueOf(player.getUniqueId()));
    }

    public static void checkStored(Player player) {
        if (!Yaml.isStoredPlayer(player)) {
            Yaml.storePlayer(player);
        }
    }

    public static boolean isFavorite(Player player, String map) {
        Yaml.checkStored(player);
        return MapSelector.getPlugin().getCacheConfig().getYml().getBoolean(player.getUniqueId() + ".favorite-maps." + map);
    }

    public static void setFavorite(Player player, String map) {
        Yaml.checkStored(player);
        MapSelector.getPlugin().getCacheConfig().set(player.getUniqueId() + ".favorite-maps." + map, Boolean.TRUE);
    }

    public static void unsetFavorite(Player player, String map) {
        Yaml.checkStored(player);
        MapSelector.getPlugin().getCacheConfig().set(player.getUniqueId() + ".favorite-maps." + map, Boolean.FALSE);
    }

    public static List<IArena> getFavorites(Player player, String group) {
        Yaml.checkStored(player);
        ArrayList<IArena> favoriteMaps = new ArrayList<IArena>();
        for (IArena arena : Arena.getArenas()) {
            if (!arena.getGroup().equalsIgnoreCase(group) || !arena.getStatus().equals((Object)GameState.waiting) && !arena.getStatus().equals((Object)GameState.starting) || !MapSelector.getPlugin().getCacheConfig().getBoolean(player.getUniqueId() + ".favorite-maps." + arena.getArenaName())) continue;
            favoriteMaps.add(arena);
        }
        return favoriteMaps;
    }

    public static List<CachedArena> getFavoritesBungee(Player player, String group) {
        Yaml.checkStored(player);
        ArrayList<CachedArena> favoriteMaps = new ArrayList<CachedArena>();
        for (CachedArena arena : ArenaManager.getArenas()) {
            if (!arena.getArenaGroup().equalsIgnoreCase(group) || !arena.getStatus().equals((Object)ArenaStatus.WAITING) && !arena.getStatus().equals((Object)ArenaStatus.STARTING) || !MapSelector.getPlugin().getCacheConfig().getBoolean(player.getUniqueId() + ".favorite-maps." + arena.getArenaName())) continue;
            favoriteMaps.add(arena);
        }
        return favoriteMaps;
    }

    public static void addMapJoin(Player player, String map) {
        Yaml.checkStored(player);
        MapSelector.getPlugin().getCacheConfig().set(player.getUniqueId() + ".per-map-times-joined." + map, MapSelector.getPlugin().getCacheConfig().getInt(player.getUniqueId() + ".per-map-times-joined." + map) + 1);
    }

    public static int getMapJoins(Player player, String map) {
        Yaml.checkStored(player);
        return MapSelector.getPlugin().getCacheConfig().getInt(player.getUniqueId() + ".per-map-times-joined." + map);
    }
}

