/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore;

import buscript.multiverse.Buscript;
import com.onarandombox.MultiverseCore.MVWorld;
import com.onarandombox.MultiverseCore.MultiverseCoreConfiguration;
import com.onarandombox.MultiverseCore.WorldProperties;
import com.onarandombox.MultiverseCore.api.BlockSafety;
import com.onarandombox.MultiverseCore.api.Core;
import com.onarandombox.MultiverseCore.api.LocationManipulation;
import com.onarandombox.MultiverseCore.api.MVPlugin;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import com.onarandombox.MultiverseCore.api.MultiverseCoreConfig;
import com.onarandombox.MultiverseCore.api.MultiverseMessaging;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.api.SafeTTeleporter;
import com.onarandombox.MultiverseCore.commands.AnchorCommand;
import com.onarandombox.MultiverseCore.commands.CheckCommand;
import com.onarandombox.MultiverseCore.commands.CloneCommand;
import com.onarandombox.MultiverseCore.commands.ConfigCommand;
import com.onarandombox.MultiverseCore.commands.ConfirmCommand;
import com.onarandombox.MultiverseCore.commands.CoordCommand;
import com.onarandombox.MultiverseCore.commands.CreateCommand;
import com.onarandombox.MultiverseCore.commands.DebugCommand;
import com.onarandombox.MultiverseCore.commands.DeleteCommand;
import com.onarandombox.MultiverseCore.commands.EnvironmentCommand;
import com.onarandombox.MultiverseCore.commands.GameruleCommand;
import com.onarandombox.MultiverseCore.commands.GamerulesCommand;
import com.onarandombox.MultiverseCore.commands.GeneratorCommand;
import com.onarandombox.MultiverseCore.commands.HelpCommand;
import com.onarandombox.MultiverseCore.commands.ImportCommand;
import com.onarandombox.MultiverseCore.commands.InfoCommand;
import com.onarandombox.MultiverseCore.commands.ListCommand;
import com.onarandombox.MultiverseCore.commands.LoadCommand;
import com.onarandombox.MultiverseCore.commands.ModifyAddCommand;
import com.onarandombox.MultiverseCore.commands.ModifyClearCommand;
import com.onarandombox.MultiverseCore.commands.ModifyCommand;
import com.onarandombox.MultiverseCore.commands.ModifyRemoveCommand;
import com.onarandombox.MultiverseCore.commands.ModifySetCommand;
import com.onarandombox.MultiverseCore.commands.PurgeCommand;
import com.onarandombox.MultiverseCore.commands.RegenCommand;
import com.onarandombox.MultiverseCore.commands.ReloadCommand;
import com.onarandombox.MultiverseCore.commands.RemoveCommand;
import com.onarandombox.MultiverseCore.commands.ScriptCommand;
import com.onarandombox.MultiverseCore.commands.SetSpawnCommand;
import com.onarandombox.MultiverseCore.commands.SilentCommand;
import com.onarandombox.MultiverseCore.commands.SpawnCommand;
import com.onarandombox.MultiverseCore.commands.TeleportCommand;
import com.onarandombox.MultiverseCore.commands.UnloadCommand;
import com.onarandombox.MultiverseCore.commands.VersionCommand;
import com.onarandombox.MultiverseCore.commands.WhoCommand;
import com.onarandombox.MultiverseCore.destination.AnchorDestination;
import com.onarandombox.MultiverseCore.destination.BedDestination;
import com.onarandombox.MultiverseCore.destination.CannonDestination;
import com.onarandombox.MultiverseCore.destination.DestinationFactory;
import com.onarandombox.MultiverseCore.destination.ExactDestination;
import com.onarandombox.MultiverseCore.destination.PlayerDestination;
import com.onarandombox.MultiverseCore.destination.WorldDestination;
import com.onarandombox.MultiverseCore.listeners.MVAsyncPlayerChatListener;
import com.onarandombox.MultiverseCore.listeners.MVChatListener;
import com.onarandombox.MultiverseCore.listeners.MVEntityListener;
import com.onarandombox.MultiverseCore.listeners.MVMapListener;
import com.onarandombox.MultiverseCore.listeners.MVPlayerChatListener;
import com.onarandombox.MultiverseCore.listeners.MVPlayerListener;
import com.onarandombox.MultiverseCore.listeners.MVPortalListener;
import com.onarandombox.MultiverseCore.listeners.MVWeatherListener;
import com.onarandombox.MultiverseCore.listeners.MVWorldInitListener;
import com.onarandombox.MultiverseCore.listeners.MVWorldListener;
import com.onarandombox.MultiverseCore.utils.AnchorManager;
import com.onarandombox.MultiverseCore.utils.CoreLogging;
import com.onarandombox.MultiverseCore.utils.MVEconomist;
import com.onarandombox.MultiverseCore.utils.MVMessaging;
import com.onarandombox.MultiverseCore.utils.MVPermissions;
import com.onarandombox.MultiverseCore.utils.MVPlayerSession;
import com.onarandombox.MultiverseCore.utils.SimpleBlockSafety;
import com.onarandombox.MultiverseCore.utils.SimpleLocationManipulation;
import com.onarandombox.MultiverseCore.utils.SimpleSafeTTeleporter;
import com.onarandombox.MultiverseCore.utils.UnsafeCallWrapper;
import com.onarandombox.MultiverseCore.utils.VaultHandler;
import com.onarandombox.MultiverseCore.utils.WorldManager;
import com.pneumaticraft.commandhandler.multiverse.CommandHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import me.main__.util.multiverse.SerializationConfig.NoSuchPropertyException;
import me.main__.util.multiverse.SerializationConfig.SerializationConfig;
import org.bukkit.ChatColor;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.mcstats.multiverse.Metrics;

public class MultiverseCore
extends JavaPlugin
implements MVPlugin,
Core {
    private static final int PROTOCOL = 20;
    private static Map<String, String> teleportQueue = new HashMap<String, String>();
    private AnchorManager anchorManager = new AnchorManager(this);
    private volatile MultiverseCoreConfiguration config;
    private CommandHandler commandHandler;
    private static final String LOG_TAG = "[Multiverse-Core]";
    private MVPermissions ph;
    private FileConfiguration multiverseConfig = null;
    private final MVWorldManager worldManager = new WorldManager(this);
    private final MVPlayerListener playerListener = new MVPlayerListener(this);
    private final MVEntityListener entityListener = new MVEntityListener(this);
    private final MVWeatherListener weatherListener = new MVWeatherListener(this);
    private final MVPortalListener portalListener = new MVPortalListener(this);
    private final MVWorldListener worldListener = new MVWorldListener(this);
    private MVChatListener chatListener;
    private HashMap<String, MVPlayerSession> playerSessions;
    private MVEconomist economist;
    private Buscript buscript;
    private int pluginCount;
    private DestinationFactory destFactory;
    private MultiverseMessaging messaging;
    private BlockSafety blockSafety;
    private LocationManipulation locationManipulation;
    private SafeTTeleporter safeTTeleporter;
    private UnsafeCallWrapper unsafeCallWrapper;
    private File serverFolder = new File(System.getProperty("user.dir"));
    private static final char PATH_SEPARATOR = '\uf8ff';

    public MultiverseCore() {
    }

    public MultiverseCore(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
    }

    public static String getPlayerTeleporter(String playerName) {
        if (teleportQueue.containsKey(playerName)) {
            String teleportee = teleportQueue.get(playerName);
            teleportQueue.remove(playerName);
            return teleportee;
        }
        return null;
    }

    public static void addPlayerToTeleportQueue(String teleporter, String teleportee) {
        CoreLogging.finest("Adding mapping '%s' => '%s' to teleport queue", teleporter, teleportee);
        teleportQueue.put(teleportee, teleporter);
    }

    public String toString() {
        return "The Multiverse-Core Plugin";
    }

    @Override
    @Deprecated
    public String dumpVersionInfo(String buffer) {
        return buffer;
    }

    @Override
    public MultiverseCore getCore() {
        return this;
    }

    @Override
    public void setCore(MultiverseCore core) {
    }

    @Override
    public int getProtocolVersion() {
        return 20;
    }

    public void onLoad() {
        SerializationConfig.registerAll(MultiverseCoreConfiguration.class);
        SerializationConfig.registerAll(WorldProperties.class);
        this.getDataFolder().mkdirs();
        CoreLogging.init((Plugin)this);
        SerializationConfig.initLogging(CoreLogging.getLogger());
        this.blockSafety = new SimpleBlockSafety(this);
        this.locationManipulation = new SimpleLocationManipulation();
        this.safeTTeleporter = new SimpleSafeTTeleporter(this);
        this.unsafeCallWrapper = new UnsafeCallWrapper(this);
    }

    @Override
    @Deprecated
    public VaultHandler getVaultHandler() {
        return this.getEconomist().getVaultHandler();
    }

    @Override
    public MVEconomist getEconomist() {
        return this.economist;
    }

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)new MVWorldInitListener(this), (Plugin)this);
        this.messaging = new MVMessaging();
        this.economist = new MVEconomist((Plugin)this);
        this.worldManager.getDefaultWorldGenerators();
        this.registerEvents();
        this.ph = new MVPermissions(this);
        this.commandHandler = new CommandHandler((Plugin)this, this.ph);
        this.registerCommands();
        this.initializeDestinationFactory();
        this.playerSessions = new HashMap();
        this.loadConfigs();
        if (this.multiverseConfig != null) {
            CoreLogging.setDebugLevel(this.getMVConfig().getGlobalDebug());
            CoreLogging.setShowingConfig(!this.getMVConfig().getSilentStart());
            this.worldManager.loadDefaultWorlds();
            this.worldManager.loadWorlds(true);
        } else {
            this.log(Level.SEVERE, "Your configs were not loaded. Very little will function in Multiverse.");
        }
        this.anchorManager.loadAnchors();
        this.worldManager.setFirstSpawnWorld(this.getMVConfig().getFirstSpawnWorld());
        try {
            this.getMVConfig().setFirstSpawnWorld(this.worldManager.getFirstSpawnWorld().getName());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.saveMVConfig();
        try {
            Class.forName("org.bukkit.event.player.AsyncPlayerChatEvent");
        }
        catch (ClassNotFoundException e) {
            this.getMVConfig().setUseAsyncChat(false);
        }
        this.chatListener = this.getMVConfig().getUseAsyncChat() ? new MVAsyncPlayerChatListener(this, this.playerListener) : new MVPlayerChatListener(this, this.playerListener);
        this.getServer().getPluginManager().registerEvents((Listener)this.chatListener, (Plugin)this);
        this.initializeBuscript();
        this.setupMetrics();
        CoreLogging.config("Version %s (API v%s) Enabled - By %s", this.getDescription().getVersion(), 20, this.getAuthors());
    }

    private void initializeBuscript() {
        this.buscript = new Buscript((Plugin)this);
        this.buscript.getGlobalScope().put("multiverse", this.buscript.getGlobalScope(), (Object)this);
    }

    private void setupMetrics() {
        try {
            Metrics m = new Metrics((Plugin)this);
            Metrics.Graph envGraph = m.createGraph("Worlds by environment");
            for (World.Environment env : World.Environment.values()) {
                envGraph.addPlotter(new EnvironmentPlotter(this, env));
            }
            Metrics.Graph loadedWorldsGraph = m.createGraph("Worlds by environment");
            loadedWorldsGraph.addPlotter(new Metrics.Plotter("Loaded worlds"){

                @Override
                public int getValue() {
                    return MultiverseCore.this.getMVWorldManager().getMVWorlds().size();
                }
            });
            loadedWorldsGraph.addPlotter(new Metrics.Plotter("Total number of worlds"){

                @Override
                public int getValue() {
                    return MultiverseCore.this.getMVWorldManager().getMVWorlds().size() + MultiverseCore.this.getMVWorldManager().getUnloadedWorlds().size();
                }
            });
            HashSet<String> gens = new HashSet<String>();
            for (MultiverseWorld w : this.getMVWorldManager().getMVWorlds()) {
                gens.add(w.getGenerator());
            }
            gens.remove(null);
            gens.remove("null");
            Metrics.Graph genGraph = m.createGraph("Custom Generators");
            for (String gen : gens) {
                genGraph.addPlotter(new GeneratorPlotter(this, gen));
            }
            m.start();
            this.log(Level.FINE, "Metrics have run!");
        }
        catch (Exception e) {
            this.log(Level.WARNING, "There was an issue while enabling metrics: " + e.getMessage());
        }
    }

    private void initializeDestinationFactory() {
        this.destFactory = new DestinationFactory(this);
        this.destFactory.registerDestinationType(WorldDestination.class, "");
        this.destFactory.registerDestinationType(WorldDestination.class, "w");
        this.destFactory.registerDestinationType(ExactDestination.class, "e");
        this.destFactory.registerDestinationType(PlayerDestination.class, "pl");
        this.destFactory.registerDestinationType(CannonDestination.class, "ca");
        this.destFactory.registerDestinationType(BedDestination.class, "b");
        this.destFactory.registerDestinationType(AnchorDestination.class, "a");
    }

    private void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)this.playerListener, (Plugin)this);
        pm.registerEvents((Listener)this.entityListener, (Plugin)this);
        pm.registerEvents((Listener)this.weatherListener, (Plugin)this);
        pm.registerEvents((Listener)this.portalListener, (Plugin)this);
        pm.registerEvents((Listener)this.worldListener, (Plugin)this);
        pm.registerEvents((Listener)new MVMapListener(this), (Plugin)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void loadConfigs() {
        this.multiverseConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "config.yml"));
        InputStream resourceURL = this.getClass().getResourceAsStream("/defaults/config.yml");
        try {
            YamlConfiguration coreDefaults = YamlConfiguration.loadConfiguration((Reader)new BufferedReader(new InputStreamReader(resourceURL, "UTF-8")));
            this.multiverseConfig.setDefaults((Configuration)coreDefaults);
        }
        catch (UnsupportedEncodingException e) {
            CoreLogging.severe("Couldn't load default config with UTF-8 encoding. Details follow:", new Object[0]);
            e.printStackTrace();
            CoreLogging.severe("Default configs NOT loaded.", new Object[0]);
        }
        this.multiverseConfig.options().copyDefaults(false);
        this.multiverseConfig.options().copyHeader(true);
        MultiverseCoreConfiguration wantedConfig = null;
        try {
            wantedConfig = (MultiverseCoreConfiguration)this.multiverseConfig.get("multiverse-configuration");
            this.config = wantedConfig == null ? new MultiverseCoreConfiguration() : wantedConfig;
        }
        catch (Exception exception) {
            this.config = wantedConfig == null ? new MultiverseCoreConfiguration() : wantedConfig;
            catch (Throwable throwable) {
                this.config = wantedConfig == null ? new MultiverseCoreConfiguration() : wantedConfig;
                throw throwable;
            }
        }
        this.migrateWorldConfig();
        this.worldManager.loadWorldConfig(new File(this.getDataFolder(), "worlds.yml"));
        this.messaging.setCooldown(this.getMVConfig().getMessageCooldown());
        this.multiverseConfig.set("enforcegamemodes", null);
        this.multiverseConfig.set("bedrespawn", null);
        this.multiverseConfig.set("opfallback", null);
        this.migrate22Values();
        this.saveMVConfigs();
    }

    private void migrate22Values() {
        if (this.multiverseConfig.isSet("worldnameprefix")) {
            CoreLogging.config("Migrating 'worldnameprefix'...", new Object[0]);
            this.getMVConfig().setPrefixChat(this.multiverseConfig.getBoolean("worldnameprefix"));
            this.multiverseConfig.set("worldnameprefix", null);
        }
        if (this.multiverseConfig.isSet("firstspawnworld")) {
            CoreLogging.config("Migrating 'firstspawnworld'...", new Object[0]);
            this.getMVConfig().setFirstSpawnWorld(this.multiverseConfig.getString("firstspawnworld"));
            this.multiverseConfig.set("firstspawnworld", null);
        }
        if (this.multiverseConfig.isSet("enforceaccess")) {
            CoreLogging.config("Migrating 'enforceaccess'...", new Object[0]);
            this.getMVConfig().setEnforceAccess(this.multiverseConfig.getBoolean("enforceaccess"));
            this.multiverseConfig.set("enforceaccess", null);
        }
        if (this.multiverseConfig.isSet("displaypermerrors")) {
            CoreLogging.config("Migrating 'displaypermerrors'...", new Object[0]);
            this.getMVConfig().setDisplayPermErrors(this.multiverseConfig.getBoolean("displaypermerrors"));
            this.multiverseConfig.set("displaypermerrors", null);
        }
        if (this.multiverseConfig.isSet("teleportintercept")) {
            CoreLogging.config("Migrating 'teleportintercept'...", new Object[0]);
            this.getMVConfig().setTeleportIntercept(this.multiverseConfig.getBoolean("teleportintercept"));
            this.multiverseConfig.set("teleportintercept", null);
        }
        if (this.multiverseConfig.isSet("firstspawnoverride")) {
            CoreLogging.config("Migrating 'firstspawnoverride'...", new Object[0]);
            this.getMVConfig().setFirstSpawnOverride(this.multiverseConfig.getBoolean("firstspawnoverride"));
            this.multiverseConfig.set("firstspawnoverride", null);
        }
        if (this.multiverseConfig.isSet("messagecooldown")) {
            CoreLogging.config("Migrating 'messagecooldown'...", new Object[0]);
            this.getMVConfig().setMessageCooldown(this.multiverseConfig.getInt("messagecooldown"));
            this.multiverseConfig.set("messagecooldown", null);
        }
        if (this.multiverseConfig.isSet("debug")) {
            CoreLogging.config("Migrating 'debug'...", new Object[0]);
            this.getMVConfig().setGlobalDebug(this.multiverseConfig.getInt("debug"));
            this.multiverseConfig.set("debug", null);
        }
        if (this.multiverseConfig.isSet("version")) {
            CoreLogging.config("Migrating 'version'...", new Object[0]);
            this.multiverseConfig.set("version", null);
        }
    }

    private void migrateWorldConfig() {
        YamlConfiguration wconf = new YamlConfiguration();
        wconf.options().pathSeparator('\uf8ff');
        File worldsFile = new File(this.getDataFolder(), "worlds.yml");
        try {
            wconf.load(worldsFile);
        }
        catch (IOException e) {
            this.log(Level.WARNING, "Cannot load worlds.yml");
        }
        catch (InvalidConfigurationException e) {
            this.log(Level.WARNING, "Your worlds.yml is invalid!");
        }
        if (!wconf.isConfigurationSection("worlds")) {
            this.log(Level.FINE, "No worlds to migrate!");
            return;
        }
        Map values = wconf.getConfigurationSection("worlds").getValues(false);
        boolean wasChanged = false;
        LinkedHashMap newValues = new LinkedHashMap(values.size());
        for (Map.Entry entry : values.entrySet()) {
            if (entry.getValue() instanceof WorldProperties) {
                newValues.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof ConfigurationSection) {
                GameMode gameMode;
                this.log(Level.FINE, "Migrating: " + (String)entry.getKey());
                WorldProperties worldProperties = new WorldProperties(Collections.EMPTY_MAP);
                ConfigurationSection section = (ConfigurationSection)entry.getValue();
                if (section.isConfigurationSection("animals")) {
                    ConfigurationSection animalSection = section.getConfigurationSection("animals");
                    if (animalSection.contains("spawn")) {
                        if (animalSection.isBoolean("spawn")) {
                            worldProperties.setAllowAnimalSpawn(animalSection.getBoolean("spawn"));
                        } else {
                            worldProperties.setAllowAnimalSpawn(Boolean.parseBoolean(animalSection.getString("spawn")));
                        }
                    }
                    if (animalSection.isList("exceptions")) {
                        worldProperties.getAnimalList().clear();
                        worldProperties.getAnimalList().addAll(animalSection.getStringList("exceptions"));
                    }
                }
                if (section.isConfigurationSection("monsters")) {
                    ConfigurationSection monsterSection = section.getConfigurationSection("monsters");
                    if (monsterSection.contains("spawn")) {
                        if (monsterSection.isBoolean("spawn")) {
                            worldProperties.setAllowMonsterSpawn(monsterSection.getBoolean("spawn"));
                        } else {
                            worldProperties.setAllowMonsterSpawn(Boolean.parseBoolean(monsterSection.getString("spawn")));
                        }
                    }
                    if (monsterSection.isList("exceptions")) {
                        worldProperties.getMonsterList().clear();
                        worldProperties.getMonsterList().addAll(monsterSection.getStringList("exceptions"));
                    }
                }
                if (section.isConfigurationSection("entryfee")) {
                    ConfigurationSection feeSection = section.getConfigurationSection("entryfee");
                    if (feeSection.isInt("currency")) {
                        worldProperties.setCurrency(feeSection.getInt("currency"));
                    }
                    if (feeSection.isDouble("amount")) {
                        worldProperties.setPrice(feeSection.getDouble("amount"));
                    } else if (feeSection.isInt("amount")) {
                        worldProperties.setPrice(feeSection.getInt("amount"));
                    }
                }
                if (section.isBoolean("pvp")) {
                    worldProperties.setPVPMode(section.getBoolean("pvp"));
                }
                if (section.isConfigurationSection("alias")) {
                    ConfigurationSection aliasSection = section.getConfigurationSection("alias");
                    if (aliasSection.isString("color")) {
                        worldProperties.setColor(aliasSection.getString("color"));
                    }
                    if (aliasSection.isString("name")) {
                        worldProperties.setAlias(aliasSection.getString("name"));
                    }
                }
                if (section.isList("worldblacklist")) {
                    worldProperties.getWorldBlacklist().clear();
                    worldProperties.getWorldBlacklist().addAll(section.getStringList("worldblacklist"));
                }
                if (section.isDouble("scale")) {
                    worldProperties.setScaling(section.getDouble("scale"));
                }
                if (section.isString("gamemode") && (gameMode = GameMode.valueOf((String)section.getString("gamemode").toUpperCase())) != null) {
                    worldProperties.setGameMode(gameMode);
                }
                if (section.isBoolean("hunger")) {
                    worldProperties.setHunger(section.getBoolean("hunger"));
                }
                if (section.isBoolean("hidden")) {
                    worldProperties.setHidden(section.getBoolean("hidden"));
                }
                if (section.isBoolean("autoheal")) {
                    worldProperties.setAutoHeal(section.getBoolean("autoheal"));
                }
                if (section.isString("portalform")) {
                    try {
                        worldProperties.setProperty("portalform", section.getString("portalform"), true);
                    }
                    catch (NoSuchPropertyException e) {
                        throw new RuntimeException("Who forgot to update the migrator?", e);
                    }
                }
                if (section.isString("environment")) {
                    try {
                        worldProperties.setProperty("environment", section.getString("environment"), true);
                    }
                    catch (NoSuchPropertyException e) {
                        throw new RuntimeException("Who forgot to update the migrator?", e);
                    }
                }
                if (section.isString("generator")) {
                    worldProperties.setGenerator(section.getString("generator"));
                }
                if (section.isLong("seed")) {
                    worldProperties.setSeed(section.getLong("seed"));
                }
                if (section.isBoolean("allowweather")) {
                    worldProperties.setEnableWeather(section.getBoolean("allowweather"));
                }
                if (section.isBoolean("adjustspawn")) {
                    worldProperties.setAdjustSpawn(section.getBoolean("adjustspawn"));
                }
                if (section.isBoolean("autoload")) {
                    worldProperties.setAutoLoad(section.getBoolean("autoload"));
                }
                if (section.isBoolean("bedrespawn")) {
                    worldProperties.setBedRespawn(section.getBoolean("bedrespawn"));
                }
                if (section.isConfigurationSection("spawn")) {
                    ConfigurationSection spawnSect = section.getConfigurationSection("spawn");
                    MVWorld.NullLocation spawnLoc = new MVWorld.NullLocation();
                    if (spawnSect.isDouble("yaw")) {
                        spawnLoc.setYaw((float)spawnSect.getDouble("yaw"));
                    }
                    if (spawnSect.isDouble("pitch")) {
                        spawnLoc.setPitch((float)spawnSect.getDouble("pitch"));
                    }
                    if (spawnSect.isDouble("x")) {
                        spawnLoc.setX(spawnSect.getDouble("x"));
                    }
                    if (spawnSect.isDouble("y")) {
                        spawnLoc.setY(spawnSect.getDouble("y"));
                    }
                    if (spawnSect.isDouble("z")) {
                        spawnLoc.setZ(spawnSect.getDouble("z"));
                    }
                    worldProperties.setSpawnLocation(spawnLoc);
                }
                if (section.isString("difficulty")) {
                    Difficulty difficulty;
                    try {
                        difficulty = Difficulty.valueOf((String)section.getString("difficulty").toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        this.log(Level.WARNING, "Could not parse difficulty: " + section.getString("difficulty"));
                        this.log(Level.WARNING, "Setting world " + (String)entry.getKey() + " difficulty to NORMAL");
                        difficulty = Difficulty.NORMAL;
                    }
                    if (difficulty != null) {
                        worldProperties.setDifficulty(difficulty);
                    }
                }
                if (section.isBoolean("keepspawninmemory")) {
                    worldProperties.setKeepSpawnInMemory(section.getBoolean("keepspawninmemory"));
                }
                newValues.put(entry.getKey(), worldProperties);
                wasChanged = true;
                continue;
            }
            this.log(Level.WARNING, "Removing unknown entry in the config: " + entry);
            wasChanged = true;
        }
        if (wasChanged) {
            wconf.set("worlds", null);
            ConfigurationSection rootSection = wconf.createSection("worlds");
            for (Map.Entry entry : newValues.entrySet()) {
                rootSection.set((String)entry.getKey(), entry.getValue());
            }
            try {
                wconf.save(new File(this.getDataFolder(), "worlds.yml"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public MultiverseMessaging getMessaging() {
        return this.messaging;
    }

    private void registerCommands() {
        this.commandHandler.registerCommand(new HelpCommand(this));
        this.commandHandler.registerCommand(new VersionCommand(this));
        this.commandHandler.registerCommand(new ListCommand(this));
        this.commandHandler.registerCommand(new InfoCommand(this));
        this.commandHandler.registerCommand(new CreateCommand(this));
        this.commandHandler.registerCommand(new CloneCommand(this));
        this.commandHandler.registerCommand(new ImportCommand(this));
        this.commandHandler.registerCommand(new ReloadCommand(this));
        this.commandHandler.registerCommand(new SetSpawnCommand(this));
        this.commandHandler.registerCommand(new CoordCommand(this));
        this.commandHandler.registerCommand(new TeleportCommand(this));
        this.commandHandler.registerCommand(new WhoCommand(this));
        this.commandHandler.registerCommand(new SpawnCommand(this));
        this.commandHandler.registerCommand(new UnloadCommand(this));
        this.commandHandler.registerCommand(new LoadCommand(this));
        this.commandHandler.registerCommand(new RemoveCommand(this));
        this.commandHandler.registerCommand(new DeleteCommand(this));
        this.commandHandler.registerCommand(new RegenCommand(this));
        this.commandHandler.registerCommand(new ConfirmCommand(this));
        this.commandHandler.registerCommand(new ModifyCommand(this));
        this.commandHandler.registerCommand(new PurgeCommand(this));
        this.commandHandler.registerCommand(new ModifyAddCommand(this));
        this.commandHandler.registerCommand(new ModifySetCommand(this));
        this.commandHandler.registerCommand(new ModifyRemoveCommand(this));
        this.commandHandler.registerCommand(new ModifyClearCommand(this));
        this.commandHandler.registerCommand(new ConfigCommand(this));
        this.commandHandler.registerCommand(new AnchorCommand(this));
        this.commandHandler.registerCommand(new EnvironmentCommand(this));
        this.commandHandler.registerCommand(new DebugCommand(this));
        this.commandHandler.registerCommand(new SilentCommand(this));
        this.commandHandler.registerCommand(new GeneratorCommand(this));
        this.commandHandler.registerCommand(new CheckCommand(this));
        this.commandHandler.registerCommand(new ScriptCommand(this));
        this.commandHandler.registerCommand(new GameruleCommand(this));
        this.commandHandler.registerCommand(new GamerulesCommand(this));
    }

    public void onDisable() {
        this.saveMVConfigs();
        CoreLogging.shutdown();
    }

    @Override
    public MVPlayerSession getPlayerSession(Player player) {
        if (this.playerSessions.containsKey(player.getName())) {
            return this.playerSessions.get(player.getName());
        }
        this.playerSessions.put(player.getName(), new MVPlayerSession(player, this.getMVConfig()));
        return this.playerSessions.get(player.getName());
    }

    @Override
    @Deprecated
    public com.onarandombox.MultiverseCore.utils.SafeTTeleporter getTeleporter() {
        return new com.onarandombox.MultiverseCore.utils.SafeTTeleporter(this);
    }

    @Override
    public MVPermissions getMVPerms() {
        return this.ph;
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        if (!this.isEnabled()) {
            sender.sendMessage("This plugin is Disabled!");
            return true;
        }
        ArrayList<String> allArgs = new ArrayList<String>(Arrays.asList(args));
        allArgs.add(0, command.getName());
        try {
            return this.commandHandler.locateAndRunCommand(sender, allArgs, this.getMVConfig().getDisplayPermErrors());
        }
        catch (Exception e) {
            e.printStackTrace();
            sender.sendMessage(ChatColor.RED + "An internal error occurred when attempting to perform this command.");
            if (sender.isOp()) {
                sender.sendMessage(ChatColor.RED + "Details were printed to the server console and logs, please add that to your bug report.");
            } else {
                sender.sendMessage(ChatColor.RED + "Try again and contact the server owner or an admin if this problem persists.");
            }
            return true;
        }
    }

    @Override
    public void log(Level level, String msg) {
        CoreLogging.log(level, msg, new Object[0]);
    }

    @Deprecated
    public static void staticLog(Level level, String msg) {
        CoreLogging.log(level, msg, new Object[0]);
    }

    @Deprecated
    public static void staticDebugLog(Level level, String msg) {
        CoreLogging.log(level, msg, new Object[0]);
    }

    @Override
    public String getAuthors() {
        String authors = "";
        List auths = this.getDescription().getAuthors();
        if (auths.size() == 0) {
            return "";
        }
        if (auths.size() == 1) {
            return (String)auths.get(0);
        }
        for (int i = 0; i < auths.size(); ++i) {
            authors = i == this.getDescription().getAuthors().size() - 1 ? authors + " and " + (String)this.getDescription().getAuthors().get(i) : authors + ", " + (String)this.getDescription().getAuthors().get(i);
        }
        return authors.substring(2);
    }

    @Override
    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public String getTag() {
        return LOG_TAG;
    }

    public void showNotMVWorldMessage(CommandSender sender, String worldName) {
        sender.sendMessage("Multiverse doesn't know about " + ChatColor.DARK_AQUA + worldName + ChatColor.WHITE + " yet.");
        sender.sendMessage("Type " + ChatColor.DARK_AQUA + "/mv import ?" + ChatColor.WHITE + " for help!");
    }

    public void removePlayerSession(Player player) {
        if (this.playerSessions.containsKey(player.getName())) {
            this.playerSessions.remove(player.getName());
        }
    }

    @Override
    public int getPluginCount() {
        return this.pluginCount;
    }

    @Override
    public void incrementPluginCount() {
        ++this.pluginCount;
    }

    @Override
    public void decrementPluginCount() {
        --this.pluginCount;
    }

    @Override
    public DestinationFactory getDestFactory() {
        return this.destFactory;
    }

    public void teleportPlayer(CommandSender teleporter, Player p, Location l) {
        this.getSafeTTeleporter().safelyTeleport(teleporter, (Entity)p, l, false);
    }

    public File getServerFolder() {
        return this.serverFolder;
    }

    public void setServerFolder(File newServerFolder) {
        if (!newServerFolder.isDirectory()) {
            throw new IllegalArgumentException("That's not a folder!");
        }
        this.serverFolder = newServerFolder;
    }

    @Override
    public MVWorldManager getMVWorldManager() {
        return this.worldManager;
    }

    public MVPlayerListener getPlayerListener() {
        return this.playerListener;
    }

    public MVChatListener getChatListener() {
        return this.chatListener;
    }

    public MVEntityListener getEntityListener() {
        return this.entityListener;
    }

    public MVWeatherListener getWeatherListener() {
        return this.weatherListener;
    }

    public boolean saveMVConfig() {
        try {
            this.multiverseConfig.set("multiverse-configuration", (Object)this.getMVConfig());
            this.multiverseConfig.save(new File(this.getDataFolder(), "config.yml"));
            return true;
        }
        catch (IOException e) {
            this.log(Level.SEVERE, "Could not save Multiverse config.yml config. Please check your file permissions.");
            return false;
        }
    }

    public boolean saveWorldConfig() {
        return this.worldManager.saveWorldsConfig();
    }

    @Override
    public boolean saveMVConfigs() {
        return this.saveMVConfig() && this.saveWorldConfig();
    }

    public Boolean deleteWorld(String name) {
        return this.worldManager.deleteWorld(name);
    }

    public Boolean cloneWorld(String oldName, String newName, String generator) {
        return this.worldManager.cloneWorld(oldName, newName, generator);
    }

    @Override
    @Deprecated
    public Boolean regenWorld(String name, Boolean useNewSeed, Boolean randomSeed, String seed) {
        return this.worldManager.regenWorld(name, useNewSeed, randomSeed, seed);
    }

    @Override
    public AnchorManager getAnchorManager() {
        return this.anchorManager;
    }

    @Override
    public BlockSafety getBlockSafety() {
        return this.blockSafety;
    }

    @Override
    public void setBlockSafety(BlockSafety bs) {
        if (bs == null) {
            throw new NullPointerException("block safety may not be null.");
        }
        this.blockSafety = bs;
    }

    @Override
    public LocationManipulation getLocationManipulation() {
        return this.locationManipulation;
    }

    @Override
    public void setLocationManipulation(LocationManipulation locationManipulation) {
        this.locationManipulation = locationManipulation;
    }

    @Override
    public SafeTTeleporter getSafeTTeleporter() {
        return this.safeTTeleporter;
    }

    @Override
    public void setSafeTTeleporter(SafeTTeleporter safeTTeleporter) {
        this.safeTTeleporter = safeTTeleporter;
    }

    @Override
    public MultiverseCoreConfig getMVConfig() {
        return this.config;
    }

    @Deprecated
    public static MultiverseCoreConfiguration getStaticConfig() {
        return MultiverseCoreConfiguration.getInstance();
    }

    @Override
    public Buscript getScriptAPI() {
        return this.buscript;
    }

    public UnsafeCallWrapper getUnsafeCallWrapper() {
        return this.unsafeCallWrapper;
    }

    private static final class GeneratorPlotter
    extends Metrics.Plotter {
        private MultiverseCore core;
        private final String gen;

        public GeneratorPlotter(MultiverseCore core, String gen) {
            super(gen);
            this.core = core;
            this.gen = gen;
        }

        @Override
        public int getValue() {
            int count = 0;
            for (MultiverseWorld w : this.core.getMVWorldManager().getMVWorlds()) {
                if (!this.gen.equals(w.getGenerator())) continue;
                ++count;
            }
            this.core.log(Level.FINE, String.format("Tracking %d worlds of type %s", count, this.gen));
            return count;
        }
    }

    private static final class EnvironmentPlotter
    extends Metrics.Plotter {
        private MultiverseCore core;
        private final World.Environment env;

        public EnvironmentPlotter(MultiverseCore core, World.Environment env) {
            super(EnvironmentPlotter.envToString(env));
            this.core = core;
            this.env = env;
        }

        private static String envToString(World.Environment env) {
            return env.name().toUpperCase().charAt(0) + env.name().toLowerCase().substring(1);
        }

        @Override
        public int getValue() {
            int count = 0;
            for (MultiverseWorld w : this.core.getMVWorldManager().getMVWorlds()) {
                if (w.getEnvironment() != this.env) continue;
                ++count;
            }
            this.core.log(Level.FINE, String.format("Tracking %d worlds of type %s", count, this.env));
            return count;
        }
    }
}

