/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore;

import com.onarandombox.MultiverseCore.api.MultiverseCoreConfig;
import com.onarandombox.MultiverseCore.utils.CoreLogging;
import java.util.Map;
import me.main__.util.multiverse.SerializationConfig.NoSuchPropertyException;
import me.main__.util.multiverse.SerializationConfig.Property;
import me.main__.util.multiverse.SerializationConfig.SerializationConfig;

public class MultiverseCoreConfiguration
extends SerializationConfig
implements MultiverseCoreConfig {
    private static MultiverseCoreConfiguration instance;
    @Property
    private volatile boolean enforceaccess;
    @Property
    private volatile boolean prefixchat;
    @Property
    private volatile String prefixchatformat;
    @Property
    private volatile boolean useasyncchat;
    @Property
    private volatile boolean teleportintercept;
    @Property
    private volatile boolean firstspawnoverride;
    @Property
    private volatile boolean displaypermerrors;
    @Property
    private volatile int globaldebug;
    @Property
    private volatile boolean silentstart;
    @Property
    private volatile int messagecooldown;
    @Property
    private volatile double version;
    @Property
    private volatile String firstspawnworld;
    @Property
    private volatile int teleportcooldown;
    @Property
    private volatile boolean defaultportalsearch;
    @Property
    private volatile int portalsearchradius;

    public static void setInstance(MultiverseCoreConfiguration instance) {
        MultiverseCoreConfiguration.instance = instance;
    }

    public static boolean isSet() {
        return instance != null;
    }

    public static MultiverseCoreConfiguration getInstance() {
        if (instance == null) {
            throw new IllegalStateException("The instance wasn't set!");
        }
        return instance;
    }

    public MultiverseCoreConfiguration() {
        MultiverseCoreConfiguration.setInstance(this);
    }

    public MultiverseCoreConfiguration(Map<String, Object> values) {
        super(values);
        MultiverseCoreConfiguration.setInstance(this);
    }

    @Override
    protected void setDefaults() {
        this.enforceaccess = false;
        this.useasyncchat = true;
        this.prefixchat = true;
        this.prefixchatformat = "[%world%]%chat%";
        this.teleportintercept = true;
        this.firstspawnoverride = true;
        this.displaypermerrors = true;
        this.globaldebug = 0;
        this.messagecooldown = 5000;
        this.teleportcooldown = 1000;
        this.version = 2.9;
        this.silentstart = false;
        this.defaultportalsearch = false;
        this.portalsearchradius = 128;
    }

    @Override
    public boolean setConfigProperty(String property, String value) {
        try {
            return this.setProperty(property, value, true);
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
    }

    @Override
    public boolean getEnforceAccess() {
        return this.enforceaccess;
    }

    @Override
    public void setEnforceAccess(boolean enforceAccess) {
        this.enforceaccess = enforceAccess;
    }

    @Override
    public boolean getPrefixChat() {
        return this.prefixchat;
    }

    @Override
    public void setPrefixChat(boolean prefixChat) {
        this.prefixchat = prefixChat;
    }

    @Override
    public String getPrefixChatFormat() {
        return this.prefixchatformat;
    }

    @Override
    public void setPrefixChatFormat(String prefixChatFormat) {
        this.prefixchatformat = prefixChatFormat;
    }

    @Override
    public boolean getTeleportIntercept() {
        return this.teleportintercept;
    }

    @Override
    public void setTeleportIntercept(boolean teleportIntercept) {
        this.teleportintercept = teleportIntercept;
    }

    @Override
    public boolean getFirstSpawnOverride() {
        return this.firstspawnoverride;
    }

    @Override
    public void setFirstSpawnOverride(boolean firstSpawnOverride) {
        this.firstspawnoverride = firstSpawnOverride;
    }

    @Override
    public boolean getDisplayPermErrors() {
        return this.displaypermerrors;
    }

    @Override
    public void setDisplayPermErrors(boolean displayPermErrors) {
        this.displaypermerrors = displayPermErrors;
    }

    @Override
    public int getGlobalDebug() {
        return this.globaldebug;
    }

    @Override
    public void setGlobalDebug(int globalDebug) {
        this.globaldebug = globalDebug;
        CoreLogging.setDebugLevel(globalDebug);
    }

    @Override
    public int getMessageCooldown() {
        return this.messagecooldown;
    }

    @Override
    public void setMessageCooldown(int messageCooldown) {
        this.messagecooldown = messageCooldown;
    }

    @Override
    public double getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public String getFirstSpawnWorld() {
        return this.firstspawnworld;
    }

    @Override
    public void setFirstSpawnWorld(String firstSpawnWorld) {
        this.firstspawnworld = firstSpawnWorld;
    }

    @Override
    public int getTeleportCooldown() {
        return this.teleportcooldown;
    }

    @Override
    public void setTeleportCooldown(int teleportCooldown) {
        this.teleportcooldown = teleportCooldown;
    }

    @Override
    public void setUseAsyncChat(boolean useAsyncChat) {
        this.useasyncchat = useAsyncChat;
    }

    @Override
    public boolean getUseAsyncChat() {
        return this.useasyncchat;
    }

    @Override
    public void setSilentStart(boolean silentStart) {
        CoreLogging.setShowingConfig(!silentStart);
        this.silentstart = silentStart;
    }

    @Override
    public boolean getSilentStart() {
        return this.silentstart;
    }

    @Override
    public void setUseDefaultPortalSearch(boolean useDefaultPortalSearch) {
        this.defaultportalsearch = useDefaultPortalSearch;
    }

    @Override
    public boolean isUsingDefaultPortalSearch() {
        return this.defaultportalsearch;
    }

    @Override
    public void setPortalSearchRadius(int searchRadius) {
        this.portalsearchradius = searchRadius;
    }

    @Override
    public int getPortalSearchRadius() {
        return this.portalsearchradius;
    }
}

