/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.configuration;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;

@SerializableAs(value="MVSpawnLocation")
public class SpawnLocation
extends Location
implements ConfigurationSerializable {
    private Reference<World> worldRef;

    public SpawnLocation(double x, double y, double z) {
        super(null, x, y, z);
    }

    public SpawnLocation(double x, double y, double z, float yaw, float pitch) {
        super(null, x, y, z, yaw, pitch);
    }

    public SpawnLocation(Location loc) {
        this(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
    }

    public World getWorld() {
        return this.worldRef != null ? this.worldRef.get() : null;
    }

    public void setWorld(World world) {
        this.worldRef = new WeakReference<World>(world);
    }

    public Chunk getChunk() {
        if (this.worldRef != null && this.worldRef.get() != null) {
            return this.worldRef.get().getChunkAt((Location)this);
        }
        return null;
    }

    public Block getBlock() {
        if (this.worldRef != null && this.worldRef.get() != null) {
            return this.worldRef.get().getBlockAt((Location)this);
        }
        return null;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> serialized = new HashMap<String, Object>(5);
        serialized.put("x", this.getX());
        serialized.put("y", this.getY());
        serialized.put("z", this.getZ());
        serialized.put("pitch", Float.valueOf(this.getPitch()));
        serialized.put("yaw", Float.valueOf(this.getYaw()));
        return serialized;
    }

    public static SpawnLocation deserialize(Map<String, Object> args) {
        double x = ((Number)args.get("x")).doubleValue();
        double y = ((Number)args.get("y")).doubleValue();
        double z = ((Number)args.get("z")).doubleValue();
        float pitch = ((Number)args.get("pitch")).floatValue();
        float yaw = ((Number)args.get("yaw")).floatValue();
        return new SpawnLocation(x, y, z, yaw, pitch);
    }
}

