/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.destination;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVDestination;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class AnchorDestination
implements MVDestination {
    private boolean isValid;
    private Location location;
    private MultiverseCore plugin;
    private String name;

    @Override
    public String getIdentifier() {
        return "a";
    }

    @Override
    public Vector getVelocity() {
        return new Vector(0, 0, 0);
    }

    @Override
    public boolean isThisType(JavaPlugin plugin, String destination) {
        if (!(plugin instanceof MultiverseCore)) {
            return false;
        }
        this.plugin = (MultiverseCore)plugin;
        List<String> parsed = Arrays.asList(destination.split(":"));
        if (parsed.size() != 2) {
            return false;
        }
        return parsed.get(0).equalsIgnoreCase("a");
    }

    @Override
    public Location getLocation(Entity e) {
        return this.location;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void setDestination(JavaPlugin plugin, String destination) {
        if (!(plugin instanceof MultiverseCore)) {
            return;
        }
        this.plugin = (MultiverseCore)plugin;
        List<String> parsed = Arrays.asList(destination.split(":"));
        if (parsed.size() != 2) {
            this.isValid = false;
            return;
        }
        this.name = parsed.get(1);
        this.location = this.plugin.getAnchorManager().getAnchorLocation(parsed.get(1));
        if (this.location == null) {
            this.isValid = false;
            return;
        }
        if (!parsed.get(0).equalsIgnoreCase(this.getIdentifier())) {
            this.isValid = false;
        }
        this.isValid = true;
    }

    @Override
    public String getType() {
        return "Anchor";
    }

    @Override
    public String getName() {
        return "Anchor: " + this.name;
    }

    @Override
    public String toString() {
        if (this.isValid) {
            return "a:" + this.name;
        }
        return "i:Invalid Destination";
    }

    @Override
    public String getRequiredPermission() {
        return "multiverse.access." + this.location.getWorld().getName();
    }

    @Override
    public boolean useSafeTeleporter() {
        return false;
    }
}

