/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.utils.CoreLogging;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHandler
implements Listener {
    private Economy economy;

    public VaultHandler(Plugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)new VaultListener(), plugin);
        this.setupVaultEconomy();
    }

    private boolean setupVaultEconomy() {
        if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
            RegisteredServiceProvider economyProvider = Bukkit.getServicesManager().getRegistration(Economy.class);
            if (economyProvider != null) {
                CoreLogging.fine("Vault economy enabled.", new Object[0]);
                this.economy = (Economy)economyProvider.getProvider();
            } else {
                CoreLogging.finer("Vault economy not detected.", new Object[0]);
                this.economy = null;
            }
        } else {
            CoreLogging.finer("Vault was not found.", new Object[0]);
            this.economy = null;
        }
        return this.economy != null;
    }

    public boolean hasEconomy() {
        return this.economy != null;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    private class VaultListener
    implements Listener {
        private VaultListener() {
        }

        @EventHandler
        private void vaultEnabled(PluginEnableEvent event) {
            if (event.getPlugin() != null && event.getPlugin().getName().equals("Vault")) {
                VaultHandler.this.setupVaultEconomy();
            }
        }

        @EventHandler
        private void vaultDisabled(PluginDisableEvent event) {
            if (event.getPlugin() != null && event.getPlugin().getName().equals("Vault")) {
                CoreLogging.fine("Vault economy disabled", new Object[0]);
                VaultHandler.this.economy = null;
            }
        }
    }
}

