/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils.webpaste;

import com.onarandombox.MultiverseCore.utils.webpaste.PasteFailedException;
import com.onarandombox.MultiverseCore.utils.webpaste.PasteService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jettison.json.multiverse.JSONException;
import org.codehaus.jettison.json.multiverse.JSONObject;

public class GithubPasteService
implements PasteService {
    private final boolean isPrivate;

    public GithubPasteService(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    @Override
    public String encodeData(String data) {
        HashMap<String, String> mapData = new HashMap<String, String>();
        mapData.put("multiverse.txt", data);
        return this.encodeData(mapData);
    }

    @Override
    public String encodeData(Map<String, String> files) {
        JSONObject root = new JSONObject();
        String result = "";
        try {
            root.put("description", "Multiverse-Core Debug Info");
            root.put("public", !this.isPrivate);
            JSONObject fileList = new JSONObject();
            for (Map.Entry<String, String> entry : files.entrySet()) {
                JSONObject fileObject = new JSONObject();
                fileObject.put("content", entry.getValue());
                fileList.put(entry.getKey(), fileObject);
            }
            root.put("files", fileList);
            result = root.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public URL getPostURL() {
        try {
            return new URL("https://api.github.com/gists");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public String postData(String encodedData, URL url) throws PasteFailedException {
        OutputStreamWriter wr = null;
        BufferedReader rd = null;
        try {
            String line;
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(encodedData);
            wr.flush();
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String pastieUrl = "";
            StringBuilder responseString = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                responseString.append(line);
            }
            JSONObject response = new JSONObject(responseString.toString());
            String string = response.get("html_url").toString();
            return string;
        }
        catch (Exception e) {
            throw new PasteFailedException(e);
        }
        finally {
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (IOException iOException) {}
            }
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean supportsMultiFile() {
        return true;
    }
}

