/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.protocol1_10to1_11.packets;

import com.viaversion.viabackwards.api.data.MappedLegacyBlockItem;
import com.viaversion.viabackwards.api.rewriters.LegacyBlockItemRewriter;
import com.viaversion.viabackwards.api.rewriters.LegacyEnchantmentRewriter;
import com.viaversion.viabackwards.protocol.protocol1_10to1_11.Protocol1_10To1_11;
import com.viaversion.viabackwards.protocol.protocol1_10to1_11.storage.ChestedHorseStorage;
import com.viaversion.viabackwards.protocol.protocol1_10to1_11.storage.WindowTracker;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.data.entity.EntityTracker;
import com.viaversion.viaversion.api.data.entity.StoredEntityData;
import com.viaversion.viaversion.api.minecraft.BlockChangeRecord;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_11Types;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.item.DataItem;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.protocols.protocol1_11to1_10.EntityIdRewriter;
import com.viaversion.viaversion.protocols.protocol1_9_1_2to1_9_3_4.types.Chunk1_9_3_4Type;
import com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.ClientboundPackets1_9_3;
import com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.ServerboundPackets1_9_3;
import com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;
import java.util.Arrays;
import java.util.Optional;

public class BlockItemPackets1_11
extends LegacyBlockItemRewriter<ClientboundPackets1_9_3, ServerboundPackets1_9_3, Protocol1_10To1_11> {
    private LegacyEnchantmentRewriter enchantmentRewriter;

    public BlockItemPackets1_11(Protocol1_10To1_11 protocol) {
        super(protocol);
    }

    protected void registerPackets() {
        ((Protocol1_10To1_11)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9_3.SET_SLOT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map((Type)Type.SHORT);
                this.map(Type.ITEM);
                this.handler(BlockItemPackets1_11.this.itemToClientHandler(Type.ITEM));
                this.handler(new PacketHandler(){

                    public void handle(PacketWrapper wrapper) throws Exception {
                        if (BlockItemPackets1_11.this.isLlama(wrapper.user())) {
                            Optional horse = BlockItemPackets1_11.this.getChestedHorse(wrapper.user());
                            if (!horse.isPresent()) {
                                return;
                            }
                            ChestedHorseStorage storage = (ChestedHorseStorage)horse.get();
                            int currentSlot = ((Short)wrapper.get((Type)Type.SHORT, 0)).shortValue();
                            currentSlot = BlockItemPackets1_11.this.getNewSlotId(storage, currentSlot);
                            wrapper.set((Type)Type.SHORT, 0, (Object)Integer.valueOf(currentSlot).shortValue());
                            wrapper.set(Type.ITEM, 0, (Object)BlockItemPackets1_11.this.getNewItem(storage, currentSlot, (Item)wrapper.get(Type.ITEM, 0)));
                        }
                    }
                });
            }
        });
        ((Protocol1_10To1_11)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9_3.WINDOW_ITEMS, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map(Type.ITEM_ARRAY);
                this.handler(wrapper -> {
                    Item[] stacks = (Item[])wrapper.get(Type.ITEM_ARRAY, 0);
                    for (int i = 0; i < stacks.length; ++i) {
                        stacks[i] = BlockItemPackets1_11.this.handleItemToClient(stacks[i]);
                    }
                    if (BlockItemPackets1_11.this.isLlama(wrapper.user())) {
                        Optional horse = BlockItemPackets1_11.this.getChestedHorse(wrapper.user());
                        if (!horse.isPresent()) {
                            return;
                        }
                        ChestedHorseStorage storage = (ChestedHorseStorage)horse.get();
                        stacks = Arrays.copyOf(stacks, !storage.isChested() ? 38 : 53);
                        for (int i = stacks.length - 1; i >= 0; --i) {
                            stacks[((BlockItemPackets1_11)BlockItemPackets1_11.this).getNewSlotId((ChestedHorseStorage)storage, (int)i)] = stacks[i];
                            stacks[i] = BlockItemPackets1_11.this.getNewItem(storage, i, stacks[i]);
                        }
                        wrapper.set(Type.ITEM_ARRAY, 0, (Object)stacks);
                    }
                });
            }
        });
        this.registerEntityEquipment((ClientboundPacketType)ClientboundPackets1_9_3.ENTITY_EQUIPMENT, Type.ITEM);
        ((Protocol1_10To1_11)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9_3.PLUGIN_MESSAGE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.STRING);
                this.handler(wrapper -> {
                    if (((String)wrapper.get(Type.STRING, 0)).equalsIgnoreCase("MC|TrList")) {
                        wrapper.passthrough((Type)Type.INT);
                        int size = ((Short)wrapper.passthrough((Type)Type.UNSIGNED_BYTE)).shortValue();
                        for (int i = 0; i < size; ++i) {
                            wrapper.write(Type.ITEM, (Object)BlockItemPackets1_11.this.handleItemToClient((Item)wrapper.read(Type.ITEM)));
                            wrapper.write(Type.ITEM, (Object)BlockItemPackets1_11.this.handleItemToClient((Item)wrapper.read(Type.ITEM)));
                            boolean secondItem = (Boolean)wrapper.passthrough((Type)Type.BOOLEAN);
                            if (secondItem) {
                                wrapper.write(Type.ITEM, (Object)BlockItemPackets1_11.this.handleItemToClient((Item)wrapper.read(Type.ITEM)));
                            }
                            wrapper.passthrough((Type)Type.BOOLEAN);
                            wrapper.passthrough((Type)Type.INT);
                            wrapper.passthrough((Type)Type.INT);
                        }
                    }
                });
            }
        });
        ((Protocol1_10To1_11)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_9_3.CLICK_WINDOW, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map((Type)Type.SHORT);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.SHORT);
                this.map((Type)Type.VAR_INT);
                this.map(Type.ITEM);
                this.handler(BlockItemPackets1_11.this.itemToServerHandler(Type.ITEM));
                this.handler(wrapper -> {
                    if (BlockItemPackets1_11.this.isLlama(wrapper.user())) {
                        Optional horse = BlockItemPackets1_11.this.getChestedHorse(wrapper.user());
                        if (!horse.isPresent()) {
                            return;
                        }
                        ChestedHorseStorage storage = (ChestedHorseStorage)horse.get();
                        short clickSlot = (Short)wrapper.get((Type)Type.SHORT, 0);
                        int correctSlot = BlockItemPackets1_11.this.getOldSlotId(storage, clickSlot);
                        wrapper.set((Type)Type.SHORT, 0, (Object)Integer.valueOf(correctSlot).shortValue());
                    }
                });
            }
        });
        this.registerCreativeInvAction((ServerboundPacketType)ServerboundPackets1_9_3.CREATIVE_INVENTORY_ACTION, Type.ITEM);
        ((Protocol1_10To1_11)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9_3.CHUNK_DATA, wrapper -> {
            ClientWorld clientWorld = (ClientWorld)wrapper.user().get(ClientWorld.class);
            Chunk1_9_3_4Type type = new Chunk1_9_3_4Type(clientWorld);
            Chunk chunk = (Chunk)wrapper.passthrough((Type)type);
            this.handleChunk(chunk);
            for (CompoundTag tag : chunk.getBlockEntities()) {
                String id;
                Tag idTag = tag.get("id");
                if (!(idTag instanceof StringTag) || !(id = (String)idTag.getValue()).equals("minecraft:sign")) continue;
                ((StringTag)idTag).setValue("Sign");
            }
        });
        ((Protocol1_10To1_11)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9_3.BLOCK_CHANGE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.POSITION);
                this.map((Type)Type.VAR_INT);
                this.handler(wrapper -> {
                    int idx = (Integer)wrapper.get((Type)Type.VAR_INT, 0);
                    wrapper.set((Type)Type.VAR_INT, 0, (Object)BlockItemPackets1_11.this.handleBlockID(idx));
                });
            }
        });
        ((Protocol1_10To1_11)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9_3.MULTI_BLOCK_CHANGE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.INT);
                this.map((Type)Type.INT);
                this.map(Type.BLOCK_CHANGE_RECORD_ARRAY);
                this.handler(wrapper -> {
                    for (BlockChangeRecord record : (BlockChangeRecord[])wrapper.get(Type.BLOCK_CHANGE_RECORD_ARRAY, 0)) {
                        record.setBlockId(BlockItemPackets1_11.this.handleBlockID(record.getBlockId()));
                    }
                });
            }
        });
        ((Protocol1_10To1_11)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9_3.BLOCK_ENTITY_DATA, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.POSITION);
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map(Type.NBT);
                this.handler(wrapper -> {
                    if ((Short)wrapper.get((Type)Type.UNSIGNED_BYTE, 0) == 10) {
                        wrapper.cancel();
                    }
                    if ((Short)wrapper.get((Type)Type.UNSIGNED_BYTE, 0) == 1) {
                        CompoundTag tag = (CompoundTag)wrapper.get(Type.NBT, 0);
                        EntityIdRewriter.toClientSpawner((CompoundTag)tag, (boolean)true);
                    }
                });
            }
        });
        ((Protocol1_10To1_11)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9_3.OPEN_WINDOW, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map(Type.STRING);
                this.map(Type.COMPONENT);
                this.map((Type)Type.UNSIGNED_BYTE);
                this.handler(wrapper -> {
                    int entityId = -1;
                    if (((String)wrapper.get(Type.STRING, 0)).equals("EntityHorse")) {
                        entityId = (Integer)wrapper.passthrough((Type)Type.INT);
                    }
                    String inventory = (String)wrapper.get(Type.STRING, 0);
                    WindowTracker windowTracker = (WindowTracker)wrapper.user().get(WindowTracker.class);
                    windowTracker.setInventory(inventory);
                    windowTracker.setEntityId(entityId);
                    if (BlockItemPackets1_11.this.isLlama(wrapper.user())) {
                        wrapper.set((Type)Type.UNSIGNED_BYTE, 1, (Object)17);
                    }
                });
            }
        });
        ((Protocol1_10To1_11)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9_3.CLOSE_WINDOW, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.handler(wrapper -> {
                    WindowTracker windowTracker = (WindowTracker)wrapper.user().get(WindowTracker.class);
                    windowTracker.setInventory(null);
                    windowTracker.setEntityId(-1);
                });
            }
        });
        ((Protocol1_10To1_11)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_9_3.CLOSE_WINDOW, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.handler(wrapper -> {
                    WindowTracker windowTracker = (WindowTracker)wrapper.user().get(WindowTracker.class);
                    windowTracker.setInventory(null);
                    windowTracker.setEntityId(-1);
                });
            }
        });
        ((Protocol1_10To1_11)this.protocol).getEntityRewriter().filter().handler((event, meta) -> {
            if (meta.metaType().type().equals(Type.ITEM)) {
                meta.setValue((Object)this.handleItemToClient((Item)meta.getValue()));
            }
        });
    }

    protected void registerRewrites() {
        MappedLegacyBlockItem data = (MappedLegacyBlockItem)this.replacementData.computeIfAbsent(52, s -> new MappedLegacyBlockItem(52, -1, null, false));
        data.setBlockEntityHandler((b, tag) -> {
            EntityIdRewriter.toClientSpawner((CompoundTag)tag, (boolean)true);
            return tag;
        });
        this.enchantmentRewriter = new LegacyEnchantmentRewriter(this.nbtTagName);
        this.enchantmentRewriter.registerEnchantment(71, "\u00a7cCurse of Vanishing");
        this.enchantmentRewriter.registerEnchantment(10, "\u00a7cCurse of Binding");
        this.enchantmentRewriter.setHideLevelForEnchants(71, 10);
    }

    @Override
    public Item handleItemToClient(Item item) {
        if (item == null) {
            return null;
        }
        super.handleItemToClient(item);
        CompoundTag tag = item.tag();
        if (tag == null) {
            return item;
        }
        EntityIdRewriter.toClientItem((Item)item, (boolean)true);
        if (tag.get("ench") instanceof ListTag) {
            this.enchantmentRewriter.rewriteEnchantmentsToClient(tag, false);
        }
        if (tag.get("StoredEnchantments") instanceof ListTag) {
            this.enchantmentRewriter.rewriteEnchantmentsToClient(tag, true);
        }
        return item;
    }

    @Override
    public Item handleItemToServer(Item item) {
        if (item == null) {
            return null;
        }
        super.handleItemToServer(item);
        CompoundTag tag = item.tag();
        if (tag == null) {
            return item;
        }
        EntityIdRewriter.toServerItem((Item)item, (boolean)true);
        if (tag.contains(this.nbtTagName + "|ench")) {
            this.enchantmentRewriter.rewriteEnchantmentsToServer(tag, false);
        }
        if (tag.contains(this.nbtTagName + "|StoredEnchantments")) {
            this.enchantmentRewriter.rewriteEnchantmentsToServer(tag, true);
        }
        return item;
    }

    private boolean isLlama(UserConnection user) {
        WindowTracker tracker = (WindowTracker)user.get(WindowTracker.class);
        if (tracker.getInventory() != null && tracker.getInventory().equals("EntityHorse")) {
            EntityTracker entTracker = user.getEntityTracker(Protocol1_10To1_11.class);
            StoredEntityData entityData = entTracker.entityData(tracker.getEntityId());
            return entityData != null && entityData.type().is((EntityType)Entity1_11Types.EntityType.LIAMA);
        }
        return false;
    }

    private Optional<ChestedHorseStorage> getChestedHorse(UserConnection user) {
        EntityTracker entTracker;
        StoredEntityData entityData;
        WindowTracker tracker = (WindowTracker)user.get(WindowTracker.class);
        if (tracker.getInventory() != null && tracker.getInventory().equals("EntityHorse") && (entityData = (entTracker = user.getEntityTracker(Protocol1_10To1_11.class)).entityData(tracker.getEntityId())) != null) {
            return Optional.of((ChestedHorseStorage)entityData.get(ChestedHorseStorage.class));
        }
        return Optional.empty();
    }

    private int getNewSlotId(ChestedHorseStorage storage, int slotId) {
        int totalSlots = !storage.isChested() ? 38 : 53;
        int strength = storage.isChested() ? storage.getLiamaStrength() : 0;
        int startNonExistingFormula = 2 + 3 * strength;
        int offsetForm = 15 - 3 * strength;
        if (slotId >= startNonExistingFormula && totalSlots > slotId + offsetForm) {
            return offsetForm + slotId;
        }
        if (slotId == 1) {
            return 0;
        }
        return slotId;
    }

    private int getOldSlotId(ChestedHorseStorage storage, int slotId) {
        int strength = storage.isChested() ? storage.getLiamaStrength() : 0;
        int startNonExistingFormula = 2 + 3 * strength;
        int endNonExistingFormula = 2 + 3 * (storage.isChested() ? 5 : 0);
        int offsetForm = endNonExistingFormula - startNonExistingFormula;
        if (slotId == 1 || slotId >= startNonExistingFormula && slotId < endNonExistingFormula) {
            return 0;
        }
        if (slotId >= endNonExistingFormula) {
            return slotId - offsetForm;
        }
        if (slotId == 0) {
            return 1;
        }
        return slotId;
    }

    private Item getNewItem(ChestedHorseStorage storage, int slotId, Item current) {
        int strength = storage.isChested() ? storage.getLiamaStrength() : 0;
        int startNonExistingFormula = 2 + 3 * strength;
        int endNonExistingFormula = 2 + 3 * (storage.isChested() ? 5 : 0);
        if (slotId >= startNonExistingFormula && slotId < endNonExistingFormula) {
            return new DataItem(166, 1, 0, this.getNamedTag("\u00a74SLOT DISABLED"));
        }
        if (slotId == 1) {
            return null;
        }
        return current;
    }
}

