/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.packets;

import com.viaversion.viabackwards.ViaBackwards;
import com.viaversion.viabackwards.api.entities.storage.EntityPositionHandler;
import com.viaversion.viabackwards.api.rewriters.LegacyEntityRewriter;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.Protocol1_12_2To1_13;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.data.EntityTypeMapping;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.data.PaintingMapping;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.data.ParticleMapping;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.storage.BackwardsBlockStorage;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.storage.PlayerPositionStorage1_13;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_13Types;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.metadata.MetaType;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import com.viaversion.viaversion.api.minecraft.metadata.types.MetaType1_12;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.Particle;
import com.viaversion.viaversion.api.type.types.version.Types1_12;
import com.viaversion.viaversion.api.type.types.version.Types1_13;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.protocols.protocol1_12_1to1_12.ClientboundPackets1_12_1;
import com.viaversion.viaversion.protocols.protocol1_12_1to1_12.ServerboundPackets1_12_1;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.ClientboundPackets1_13;
import java.util.List;
import java.util.Optional;

public class EntityPackets1_13
extends LegacyEntityRewriter<ClientboundPackets1_13, Protocol1_12_2To1_13> {
    public EntityPackets1_13(Protocol1_12_2To1_13 protocol) {
        super(protocol);
    }

    protected void registerPackets() {
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.PLAYER_POSITION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.BYTE);
                this.handler(wrapper -> {
                    if (!ViaBackwards.getConfig().isFix1_13FacePlayer()) {
                        return;
                    }
                    PlayerPositionStorage1_13 playerStorage = (PlayerPositionStorage1_13)wrapper.user().get(PlayerPositionStorage1_13.class);
                    byte bitField = (Byte)wrapper.get((Type)Type.BYTE, 0);
                    playerStorage.setX(EntityPackets1_13.toSet(bitField, 0, playerStorage.getX(), (Double)wrapper.get((Type)Type.DOUBLE, 0)));
                    playerStorage.setY(EntityPackets1_13.toSet(bitField, 1, playerStorage.getY(), (Double)wrapper.get((Type)Type.DOUBLE, 1)));
                    playerStorage.setZ(EntityPackets1_13.toSet(bitField, 2, playerStorage.getZ(), (Double)wrapper.get((Type)Type.DOUBLE, 2)));
                });
            }
        });
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.SPAWN_ENTITY, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map(Type.UUID);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.INT);
                this.handler(EntityPackets1_13.this.getObjectTrackerHandler());
                this.handler(wrapper -> {
                    Optional optionalType = Entity1_13Types.ObjectType.findById((int)((Byte)wrapper.get((Type)Type.BYTE, 0)).byteValue());
                    if (!optionalType.isPresent()) {
                        return;
                    }
                    Entity1_13Types.ObjectType type = (Entity1_13Types.ObjectType)optionalType.get();
                    if (type == Entity1_13Types.ObjectType.FALLING_BLOCK) {
                        int blockState = (Integer)wrapper.get((Type)Type.INT, 0);
                        int combined = Protocol1_12_2To1_13.MAPPINGS.getNewBlockStateId(blockState);
                        combined = combined >> 4 & 0xFFF | (combined & 0xF) << 12;
                        wrapper.set((Type)Type.INT, 0, (Object)combined);
                    } else if (type == Entity1_13Types.ObjectType.ITEM_FRAME) {
                        int data = (Integer)wrapper.get((Type)Type.INT, 0);
                        switch (data) {
                            case 3: {
                                data = 0;
                                break;
                            }
                            case 4: {
                                data = 1;
                                break;
                            }
                            case 5: {
                                data = 3;
                            }
                        }
                        wrapper.set((Type)Type.INT, 0, (Object)data);
                    } else if (type == Entity1_13Types.ObjectType.TRIDENT) {
                        wrapper.set((Type)Type.BYTE, 0, (Object)((byte)Entity1_13Types.ObjectType.TIPPED_ARROW.getId()));
                    }
                });
            }
        });
        this.registerTracker((ClientboundPacketType)ClientboundPackets1_13.SPAWN_EXPERIENCE_ORB, (EntityType)Entity1_13Types.EntityType.EXPERIENCE_ORB);
        this.registerTracker((ClientboundPacketType)ClientboundPackets1_13.SPAWN_GLOBAL_ENTITY, (EntityType)Entity1_13Types.EntityType.LIGHTNING_BOLT);
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.SPAWN_MOB, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map(Type.UUID);
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.SHORT);
                this.map((Type)Type.SHORT);
                this.map((Type)Type.SHORT);
                this.map(Types1_13.METADATA_LIST, Types1_12.METADATA_LIST);
                this.handler(wrapper -> {
                    int type = (Integer)wrapper.get((Type)Type.VAR_INT, 1);
                    Entity1_13Types.EntityType entityType = Entity1_13Types.getTypeFromId((int)type, (boolean)false);
                    EntityPackets1_13.this.tracker(wrapper.user()).addEntity(((Integer)wrapper.get((Type)Type.VAR_INT, 0)).intValue(), (EntityType)entityType);
                    int oldId = EntityTypeMapping.getOldId(type);
                    if (oldId == -1) {
                        if (!EntityPackets1_13.this.hasData((EntityType)entityType)) {
                            ViaBackwards.getPlatform().getLogger().warning("Could not find 1.12 entity type for 1.13 entity type " + type + "/" + entityType);
                        }
                    } else {
                        wrapper.set((Type)Type.VAR_INT, 1, (Object)oldId);
                    }
                });
                this.handler(EntityPackets1_13.this.getMobSpawnRewriter((Type<List<Metadata>>)Types1_12.METADATA_LIST));
            }
        });
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.SPAWN_PLAYER, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map(Type.UUID);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map(Types1_13.METADATA_LIST, Types1_12.METADATA_LIST);
                this.handler(EntityPackets1_13.this.getTrackerAndMetaHandler((Type<List<Metadata>>)Types1_12.METADATA_LIST, (EntityType)Entity1_13Types.EntityType.PLAYER));
            }
        });
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.SPAWN_PAINTING, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map(Type.UUID);
                this.handler(EntityPackets1_13.this.getTrackerHandler((EntityType)Entity1_13Types.EntityType.PAINTING, (Type<Number>)((Type)Type.VAR_INT)));
                this.handler(wrapper -> {
                    int motive = (Integer)wrapper.read((Type)Type.VAR_INT);
                    String title = PaintingMapping.getStringId(motive);
                    wrapper.write(Type.STRING, (Object)title);
                });
            }
        });
        this.registerJoinGame(ClientboundPackets1_13.JOIN_GAME, (EntityType)Entity1_13Types.EntityType.PLAYER);
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.RESPAWN, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.INT);
                this.handler(EntityPackets1_13.this.getDimensionHandler(0));
                this.handler(wrapper -> ((BackwardsBlockStorage)wrapper.user().get(BackwardsBlockStorage.class)).clear());
            }
        });
        this.registerRemoveEntities((ClientboundPacketType)ClientboundPackets1_13.DESTROY_ENTITIES);
        this.registerMetadataRewriter(ClientboundPackets1_13.ENTITY_METADATA, (Type<List<Metadata>>)Types1_13.METADATA_LIST, (Type<List<Metadata>>)Types1_12.METADATA_LIST);
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.FACE_PLAYER, null, wrapper -> {
            wrapper.cancel();
            if (!ViaBackwards.getConfig().isFix1_13FacePlayer()) {
                return;
            }
            int anchor = (Integer)wrapper.read((Type)Type.VAR_INT);
            double x = (Double)wrapper.read((Type)Type.DOUBLE);
            double y = (Double)wrapper.read((Type)Type.DOUBLE);
            double z = (Double)wrapper.read((Type)Type.DOUBLE);
            PlayerPositionStorage1_13 positionStorage = (PlayerPositionStorage1_13)wrapper.user().get(PlayerPositionStorage1_13.class);
            PacketWrapper positionAndLook = wrapper.create((PacketType)ClientboundPackets1_12_1.PLAYER_POSITION);
            positionAndLook.write((Type)Type.DOUBLE, (Object)0.0);
            positionAndLook.write((Type)Type.DOUBLE, (Object)0.0);
            positionAndLook.write((Type)Type.DOUBLE, (Object)0.0);
            EntityPositionHandler.writeFacingDegrees(positionAndLook, positionStorage.getX(), anchor == 1 ? positionStorage.getY() + 1.62 : positionStorage.getY(), positionStorage.getZ(), x, y, z);
            positionAndLook.write((Type)Type.BYTE, (Object)7);
            positionAndLook.write((Type)Type.VAR_INT, (Object)-1);
            positionAndLook.send(Protocol1_12_2To1_13.class);
        });
        if (ViaBackwards.getConfig().isFix1_13FacePlayer()) {
            PacketHandlers movementRemapper = new PacketHandlers(){

                public void register() {
                    this.map((Type)Type.DOUBLE);
                    this.map((Type)Type.DOUBLE);
                    this.map((Type)Type.DOUBLE);
                    this.handler(wrapper -> ((PlayerPositionStorage1_13)wrapper.user().get(PlayerPositionStorage1_13.class)).setCoordinates(wrapper, false));
                }
            };
            ((Protocol1_12_2To1_13)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_12_1.PLAYER_POSITION, (PacketHandler)movementRemapper);
            ((Protocol1_12_2To1_13)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_12_1.PLAYER_POSITION_AND_ROTATION, (PacketHandler)movementRemapper);
            ((Protocol1_12_2To1_13)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_12_1.VEHICLE_MOVE, (PacketHandler)movementRemapper);
        }
    }

    protected void registerRewrites() {
        this.mapEntityTypeWithData((EntityType)Entity1_13Types.EntityType.DROWNED, (EntityType)Entity1_13Types.EntityType.ZOMBIE_VILLAGER).plainName();
        this.mapEntityTypeWithData((EntityType)Entity1_13Types.EntityType.COD, (EntityType)Entity1_13Types.EntityType.SQUID).plainName();
        this.mapEntityTypeWithData((EntityType)Entity1_13Types.EntityType.SALMON, (EntityType)Entity1_13Types.EntityType.SQUID).plainName();
        this.mapEntityTypeWithData((EntityType)Entity1_13Types.EntityType.PUFFERFISH, (EntityType)Entity1_13Types.EntityType.SQUID).plainName();
        this.mapEntityTypeWithData((EntityType)Entity1_13Types.EntityType.TROPICAL_FISH, (EntityType)Entity1_13Types.EntityType.SQUID).plainName();
        this.mapEntityTypeWithData((EntityType)Entity1_13Types.EntityType.PHANTOM, (EntityType)Entity1_13Types.EntityType.PARROT).plainName().spawnMetadata(storage -> storage.add(new Metadata(15, (MetaType)MetaType1_12.VarInt, (Object)3)));
        this.mapEntityTypeWithData((EntityType)Entity1_13Types.EntityType.DOLPHIN, (EntityType)Entity1_13Types.EntityType.SQUID).plainName();
        this.mapEntityTypeWithData((EntityType)Entity1_13Types.EntityType.TURTLE, (EntityType)Entity1_13Types.EntityType.OCELOT).plainName();
        this.filter().handler((event, meta) -> {
            int typeId = meta.metaType().typeId();
            if (typeId == 4) {
                JsonElement element = (JsonElement)meta.value();
                ((Protocol1_12_2To1_13)this.protocol).translatableRewriter().processText(element);
                meta.setMetaType((MetaType)MetaType1_12.Chat);
            } else if (typeId == 5) {
                JsonElement element = (JsonElement)meta.value();
                meta.setTypeAndValue((MetaType)MetaType1_12.String, (Object)((Protocol1_12_2To1_13)this.protocol).jsonToLegacy(element));
            } else if (typeId == 6) {
                Item item = (Item)meta.getValue();
                meta.setTypeAndValue((MetaType)MetaType1_12.Slot, (Object)((Protocol1_12_2To1_13)this.protocol).getItemRewriter().handleItemToClient(item));
            } else if (typeId == 15) {
                event.cancel();
            } else {
                meta.setMetaType((MetaType)MetaType1_12.byId((int)(typeId > 5 ? typeId - 1 : typeId)));
            }
        });
        this.filter().filterFamily((EntityType)Entity1_13Types.EntityType.ZOMBIE).removeIndex(15);
        this.filter().type((EntityType)Entity1_13Types.EntityType.TURTLE).cancel(13);
        this.filter().type((EntityType)Entity1_13Types.EntityType.TURTLE).cancel(14);
        this.filter().type((EntityType)Entity1_13Types.EntityType.TURTLE).cancel(15);
        this.filter().type((EntityType)Entity1_13Types.EntityType.TURTLE).cancel(16);
        this.filter().type((EntityType)Entity1_13Types.EntityType.TURTLE).cancel(17);
        this.filter().type((EntityType)Entity1_13Types.EntityType.TURTLE).cancel(18);
        this.filter().filterFamily((EntityType)Entity1_13Types.EntityType.ABSTRACT_FISHES).cancel(12);
        this.filter().filterFamily((EntityType)Entity1_13Types.EntityType.ABSTRACT_FISHES).cancel(13);
        this.filter().type((EntityType)Entity1_13Types.EntityType.PHANTOM).cancel(12);
        this.filter().type((EntityType)Entity1_13Types.EntityType.BOAT).cancel(12);
        this.filter().type((EntityType)Entity1_13Types.EntityType.TRIDENT).cancel(7);
        this.filter().type((EntityType)Entity1_13Types.EntityType.WOLF).index(17).handler((event, meta) -> meta.setValue((Object)(15 - (Integer)meta.getValue())));
        this.filter().type((EntityType)Entity1_13Types.EntityType.AREA_EFFECT_CLOUD).index(9).handler((event, meta) -> {
            Particle particle = (Particle)meta.getValue();
            ParticleMapping.ParticleData data = ParticleMapping.getMapping(particle.getId());
            int firstArg = 0;
            int secondArg = 0;
            int[] particleArgs = data.rewriteMeta((Protocol1_12_2To1_13)this.protocol, particle.getArguments());
            if (particleArgs != null && particleArgs.length != 0) {
                if (data.getHandler().isBlockHandler() && particleArgs[0] == 0) {
                    particleArgs[0] = 102;
                }
                firstArg = particleArgs[0];
                secondArg = particleArgs.length == 2 ? particleArgs[1] : 0;
            }
            event.createExtraMeta(new Metadata(9, (MetaType)MetaType1_12.VarInt, (Object)data.getHistoryId()));
            event.createExtraMeta(new Metadata(10, (MetaType)MetaType1_12.VarInt, (Object)firstArg));
            event.createExtraMeta(new Metadata(11, (MetaType)MetaType1_12.VarInt, (Object)secondArg));
            event.cancel();
        });
    }

    public EntityType typeFromId(int typeId) {
        return Entity1_13Types.getTypeFromId((int)typeId, (boolean)false);
    }

    @Override
    protected EntityType getObjectTypeFromId(int typeId) {
        return Entity1_13Types.getTypeFromId((int)typeId, (boolean)true);
    }

    public int newEntityId(int newId) {
        return EntityTypeMapping.getOldId(newId);
    }

    private static double toSet(int field, int bitIndex, double origin, double packetValue) {
        return (field & 1 << bitIndex) != 0 ? origin + packetValue : packetValue;
    }
}

