/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.protocol1_16_1to1_16_2.packets;

import com.google.common.collect.Sets;
import com.viaversion.viabackwards.ViaBackwards;
import com.viaversion.viabackwards.api.rewriters.EntityRewriter;
import com.viaversion.viabackwards.protocol.protocol1_16_1to1_16_2.Protocol1_16_1To1_16_2;
import com.viaversion.viabackwards.protocol.protocol1_16_1to1_16_2.storage.BiomeStorage;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_16Types;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_16_2Types;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.version.Types1_16;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.NumberTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.protocols.protocol1_16_2to1_16_1.ClientboundPackets1_16_2;
import com.viaversion.viaversion.protocols.protocol1_16to1_15_2.packets.EntityPackets;
import java.util.Set;

public class EntityPackets1_16_2
extends EntityRewriter<ClientboundPackets1_16_2, Protocol1_16_1To1_16_2> {
    private final Set<String> oldDimensions = Sets.newHashSet((Object[])new String[]{"minecraft:overworld", "minecraft:the_nether", "minecraft:the_end"});
    private boolean warned;

    public EntityPackets1_16_2(Protocol1_16_1To1_16_2 protocol) {
        super(protocol);
    }

    protected void registerPackets() {
        this.registerTrackerWithData(ClientboundPackets1_16_2.SPAWN_ENTITY, (EntityType)Entity1_16_2Types.FALLING_BLOCK);
        this.registerSpawnTracker(ClientboundPackets1_16_2.SPAWN_MOB);
        this.registerTracker((ClientboundPacketType)ClientboundPackets1_16_2.SPAWN_EXPERIENCE_ORB, (EntityType)Entity1_16_2Types.EXPERIENCE_ORB);
        this.registerTracker((ClientboundPacketType)ClientboundPackets1_16_2.SPAWN_PAINTING, (EntityType)Entity1_16_2Types.PAINTING);
        this.registerTracker((ClientboundPacketType)ClientboundPackets1_16_2.SPAWN_PLAYER, (EntityType)Entity1_16_2Types.PLAYER);
        this.registerRemoveEntities((ClientboundPacketType)ClientboundPackets1_16_2.DESTROY_ENTITIES);
        this.registerMetadataRewriter((ClientboundPacketType)ClientboundPackets1_16_2.ENTITY_METADATA, Types1_16.METADATA_LIST);
        ((Protocol1_16_1To1_16_2)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_16_2.JOIN_GAME, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.INT);
                this.handler(wrapper -> {
                    boolean hardcore = (Boolean)wrapper.read((Type)Type.BOOLEAN);
                    short gamemode = (Short)wrapper.read((Type)Type.UNSIGNED_BYTE);
                    if (hardcore) {
                        gamemode = (short)(gamemode | 8);
                    }
                    wrapper.write((Type)Type.UNSIGNED_BYTE, (Object)gamemode);
                });
                this.map((Type)Type.BYTE);
                this.map(Type.STRING_ARRAY);
                this.handler(wrapper -> {
                    CompoundTag registry = (CompoundTag)wrapper.read(Type.NBT);
                    if (wrapper.user().getProtocolInfo().getProtocolVersion() <= ProtocolVersion.v1_15_2.getVersion()) {
                        CompoundTag biomeRegistry = (CompoundTag)registry.get("minecraft:worldgen/biome");
                        ListTag biomes = (ListTag)biomeRegistry.get("value");
                        BiomeStorage biomeStorage = (BiomeStorage)wrapper.user().get(BiomeStorage.class);
                        biomeStorage.clear();
                        for (Tag biome : biomes) {
                            CompoundTag biomeCompound = (CompoundTag)biome;
                            StringTag name = (StringTag)biomeCompound.get("name");
                            NumberTag id = (NumberTag)biomeCompound.get("id");
                            biomeStorage.addBiome(name.getValue(), id.asInt());
                        }
                    } else if (!EntityPackets1_16_2.this.warned) {
                        EntityPackets1_16_2.this.warned = true;
                        ViaBackwards.getPlatform().getLogger().warning("1.16 and 1.16.1 clients are only partially supported and may have wrong biomes displayed.");
                    }
                    wrapper.write(Type.NBT, (Object)EntityPackets.DIMENSIONS_TAG);
                    CompoundTag dimensionData = (CompoundTag)wrapper.read(Type.NBT);
                    wrapper.write(Type.STRING, (Object)EntityPackets1_16_2.this.getDimensionFromData(dimensionData));
                });
                this.map(Type.STRING);
                this.map((Type)Type.LONG);
                this.handler(wrapper -> {
                    int maxPlayers = (Integer)wrapper.read((Type)Type.VAR_INT);
                    wrapper.write((Type)Type.UNSIGNED_BYTE, (Object)((short)Math.min(maxPlayers, 255)));
                });
                this.handler(EntityPackets1_16_2.this.getTrackerHandler((EntityType)Entity1_16_2Types.PLAYER, (Type<Number>)((Type)Type.INT)));
            }
        });
        ((Protocol1_16_1To1_16_2)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_16_2.RESPAWN, wrapper -> {
            CompoundTag dimensionData = (CompoundTag)wrapper.read(Type.NBT);
            wrapper.write(Type.STRING, (Object)this.getDimensionFromData(dimensionData));
        });
    }

    private String getDimensionFromData(CompoundTag dimensionData) {
        StringTag effectsLocation = (StringTag)dimensionData.get("effects");
        return effectsLocation != null && this.oldDimensions.contains(effectsLocation.getValue()) ? effectsLocation.getValue() : "minecraft:overworld";
    }

    protected void registerRewrites() {
        this.registerMetaTypeHandler(Types1_16.META_TYPES.itemType, Types1_16.META_TYPES.blockStateType, null, Types1_16.META_TYPES.particleType, Types1_16.META_TYPES.componentType, Types1_16.META_TYPES.optionalComponentType);
        this.mapTypes((EntityType[])Entity1_16_2Types.values(), Entity1_16Types.class);
        this.mapEntityTypeWithData((EntityType)Entity1_16_2Types.PIGLIN_BRUTE, (EntityType)Entity1_16_2Types.PIGLIN).jsonName();
        this.filter().filterFamily((EntityType)Entity1_16_2Types.ABSTRACT_PIGLIN).index(15).toIndex(16);
        this.filter().filterFamily((EntityType)Entity1_16_2Types.ABSTRACT_PIGLIN).index(16).toIndex(15);
    }

    public EntityType typeFromId(int typeId) {
        return Entity1_16_2Types.getTypeFromId((int)typeId);
    }
}

