/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.protocol1_16_4to1_17;

import com.viaversion.viabackwards.ViaBackwards;
import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.data.BackwardsMappings;
import com.viaversion.viabackwards.api.rewriters.SoundRewriter;
import com.viaversion.viabackwards.api.rewriters.TranslatableRewriter;
import com.viaversion.viabackwards.protocol.protocol1_16_4to1_17.packets.BlockItemPackets1_17;
import com.viaversion.viabackwards.protocol.protocol1_16_4to1_17.packets.EntityPackets1_17;
import com.viaversion.viabackwards.protocol.protocol1_16_4to1_17.storage.PingRequests;
import com.viaversion.viabackwards.protocol.protocol1_16_4to1_17.storage.PlayerLastCursorItem;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.data.entity.EntityTracker;
import com.viaversion.viaversion.api.minecraft.RegistryType;
import com.viaversion.viaversion.api.minecraft.TagData;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_17Types;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.data.entity.EntityTrackerBase;
import com.viaversion.viaversion.libs.fastutil.ints.IntArrayList;
import com.viaversion.viaversion.protocols.protocol1_16_2to1_16_1.ClientboundPackets1_16_2;
import com.viaversion.viaversion.protocols.protocol1_16_2to1_16_1.ServerboundPackets1_16_2;
import com.viaversion.viaversion.protocols.protocol1_17to1_16_4.ClientboundPackets1_17;
import com.viaversion.viaversion.protocols.protocol1_17to1_16_4.Protocol1_17To1_16_4;
import com.viaversion.viaversion.protocols.protocol1_17to1_16_4.ServerboundPackets1_17;
import com.viaversion.viaversion.rewriter.IdRewriteFunction;
import com.viaversion.viaversion.rewriter.StatisticsRewriter;
import com.viaversion.viaversion.rewriter.TagRewriter;
import com.viaversion.viaversion.util.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class Protocol1_16_4To1_17
extends BackwardsProtocol<ClientboundPackets1_17, ClientboundPackets1_16_2, ServerboundPackets1_17, ServerboundPackets1_16_2> {
    public static final BackwardsMappings MAPPINGS = new BackwardsMappings("1.17", "1.16.2", Protocol1_17To1_16_4.class);
    private static final RegistryType[] TAG_REGISTRY_TYPES = new RegistryType[]{RegistryType.BLOCK, RegistryType.ITEM, RegistryType.FLUID, RegistryType.ENTITY};
    private static final int[] EMPTY_ARRAY = new int[0];
    private final EntityPackets1_17 entityRewriter = new EntityPackets1_17(this);
    private final BlockItemPackets1_17 blockItemPackets = new BlockItemPackets1_17(this);
    private final TranslatableRewriter<ClientboundPackets1_17> translatableRewriter = new TranslatableRewriter<ClientboundPackets1_17>(this);

    public Protocol1_16_4To1_17() {
        super(ClientboundPackets1_17.class, ClientboundPackets1_16_2.class, ServerboundPackets1_17.class, ServerboundPackets1_16_2.class);
    }

    @Override
    protected void registerPackets() {
        super.registerPackets();
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_17.CHAT_MESSAGE);
        this.translatableRewriter.registerBossBar((ClientboundPacketType)ClientboundPackets1_17.BOSSBAR);
        this.translatableRewriter.registerDisconnect(ClientboundPackets1_17.DISCONNECT);
        this.translatableRewriter.registerTabList(ClientboundPackets1_17.TAB_LIST);
        this.translatableRewriter.registerOpenWindow(ClientboundPackets1_17.OPEN_WINDOW);
        this.translatableRewriter.registerPing();
        SoundRewriter<ClientboundPackets1_17> soundRewriter = new SoundRewriter<ClientboundPackets1_17>(this);
        soundRewriter.registerSound((ClientboundPacketType)ClientboundPackets1_17.SOUND);
        soundRewriter.registerSound((ClientboundPacketType)ClientboundPackets1_17.ENTITY_SOUND);
        soundRewriter.registerNamedSound(ClientboundPackets1_17.NAMED_SOUND);
        soundRewriter.registerStopSound(ClientboundPackets1_17.STOP_SOUND);
        TagRewriter tagRewriter = new TagRewriter((Protocol)this);
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_17.TAGS, wrapper -> {
            HashMap tags = new HashMap();
            int length = (Integer)wrapper.read((Type)Type.VAR_INT);
            for (int i = 0; i < length; ++i) {
                String resourceKey = Key.stripMinecraftNamespace((String)((String)wrapper.read(Type.STRING)));
                ArrayList<TagData> tagList = new ArrayList<TagData>();
                tags.put(resourceKey, tagList);
                int tagLength = (Integer)wrapper.read((Type)Type.VAR_INT);
                for (int j = 0; j < tagLength; ++j) {
                    String identifier = (String)wrapper.read(Type.STRING);
                    int[] entries = (int[])wrapper.read(Type.VAR_INT_ARRAY_PRIMITIVE);
                    tagList.add(new TagData(identifier, entries));
                }
            }
            for (RegistryType type : TAG_REGISTRY_TYPES) {
                List tagList = (List)tags.get(type.resourceLocation());
                if (tagList == null) {
                    wrapper.write((Type)Type.VAR_INT, (Object)0);
                    continue;
                }
                IdRewriteFunction rewriter = tagRewriter.getRewriter(type);
                wrapper.write((Type)Type.VAR_INT, (Object)tagList.size());
                for (TagData tagData : tagList) {
                    int[] entries = tagData.entries();
                    if (rewriter != null) {
                        IntArrayList idList = new IntArrayList(entries.length);
                        for (int id : entries) {
                            int mappedId = rewriter.rewrite(id);
                            if (mappedId == -1) continue;
                            idList.add(mappedId);
                        }
                        entries = idList.toArray(EMPTY_ARRAY);
                    }
                    wrapper.write(Type.STRING, (Object)tagData.identifier());
                    wrapper.write(Type.VAR_INT_ARRAY_PRIMITIVE, (Object)entries);
                }
            }
        });
        new StatisticsRewriter((Protocol)this).register((ClientboundPacketType)ClientboundPackets1_17.STATISTICS);
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_17.RESOURCE_PACK, wrapper -> {
            wrapper.passthrough(Type.STRING);
            wrapper.passthrough(Type.STRING);
            wrapper.read((Type)Type.BOOLEAN);
            wrapper.read(Type.OPTIONAL_COMPONENT);
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_17.EXPLOSION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.FLOAT);
                this.handler(wrapper -> wrapper.write((Type)Type.INT, (Object)((Integer)wrapper.read((Type)Type.VAR_INT))));
            }
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_17.SPAWN_POSITION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.POSITION1_14);
                this.handler(wrapper -> wrapper.read((Type)Type.FLOAT));
            }
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_17.PING, null, wrapper -> {
            wrapper.cancel();
            int id = (Integer)wrapper.read((Type)Type.INT);
            short shortId = (short)id;
            if (id == shortId && ViaBackwards.getConfig().handlePingsAsInvAcknowledgements()) {
                ((PingRequests)wrapper.user().get(PingRequests.class)).addId(shortId);
                PacketWrapper acknowledgementPacket = wrapper.create((PacketType)ClientboundPackets1_16_2.WINDOW_CONFIRMATION);
                acknowledgementPacket.write((Type)Type.UNSIGNED_BYTE, (Object)0);
                acknowledgementPacket.write((Type)Type.SHORT, (Object)shortId);
                acknowledgementPacket.write((Type)Type.BOOLEAN, (Object)false);
                acknowledgementPacket.send(Protocol1_16_4To1_17.class);
                return;
            }
            PacketWrapper pongPacket = wrapper.create((PacketType)ServerboundPackets1_17.PONG);
            pongPacket.write((Type)Type.INT, (Object)id);
            pongPacket.sendToServer(Protocol1_16_4To1_17.class);
        });
        this.registerServerbound((ServerboundPacketType)ServerboundPackets1_16_2.CLIENT_SETTINGS, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.STRING);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.BOOLEAN);
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map((Type)Type.VAR_INT);
                this.handler(wrapper -> wrapper.write((Type)Type.BOOLEAN, (Object)false));
            }
        });
        this.mergePacket(ClientboundPackets1_17.TITLE_TEXT, ClientboundPackets1_16_2.TITLE, 0);
        this.mergePacket(ClientboundPackets1_17.TITLE_SUBTITLE, ClientboundPackets1_16_2.TITLE, 1);
        this.mergePacket(ClientboundPackets1_17.ACTIONBAR, ClientboundPackets1_16_2.TITLE, 2);
        this.mergePacket(ClientboundPackets1_17.TITLE_TIMES, ClientboundPackets1_16_2.TITLE, 3);
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_17.CLEAR_TITLES, (ClientboundPacketType)ClientboundPackets1_16_2.TITLE, wrapper -> {
            if (((Boolean)wrapper.read((Type)Type.BOOLEAN)).booleanValue()) {
                wrapper.write((Type)Type.VAR_INT, (Object)5);
            } else {
                wrapper.write((Type)Type.VAR_INT, (Object)4);
            }
        });
        this.cancelClientbound((ClientboundPacketType)ClientboundPackets1_17.ADD_VIBRATION_SIGNAL);
    }

    public void init(UserConnection user) {
        this.addEntityTracker(user, (EntityTracker)new EntityTrackerBase(user, (EntityType)Entity1_17Types.PLAYER));
        user.put((StorableObject)new PingRequests());
        user.put((StorableObject)new PlayerLastCursorItem());
    }

    @Override
    public BackwardsMappings getMappingData() {
        return MAPPINGS;
    }

    @Override
    public TranslatableRewriter<ClientboundPackets1_17> getTranslatableRewriter() {
        return this.translatableRewriter;
    }

    public void mergePacket(ClientboundPackets1_17 newPacketType, ClientboundPackets1_16_2 oldPacketType, int type) {
        this.registerClientbound((ClientboundPacketType)newPacketType, (ClientboundPacketType)oldPacketType, wrapper -> wrapper.write((Type)Type.VAR_INT, (Object)type));
    }

    public EntityPackets1_17 getEntityRewriter() {
        return this.entityRewriter;
    }

    public BlockItemPackets1_17 getItemRewriter() {
        return this.blockItemPackets;
    }
}

