/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus;

import com.extendedclip.deluxemenus.cache.OfflinePlayerCache;
import com.extendedclip.deluxemenus.commands.DeluxeMenusCommands;
import com.extendedclip.deluxemenus.config.DeluxeMenusConfig;
import com.extendedclip.deluxemenus.hooks.BaseHeadHook;
import com.extendedclip.deluxemenus.hooks.HeadDatabaseHook;
import com.extendedclip.deluxemenus.hooks.ItemHook;
import com.extendedclip.deluxemenus.hooks.ItemsAdderHook;
import com.extendedclip.deluxemenus.hooks.TextureHeadHook;
import com.extendedclip.deluxemenus.hooks.VaultHook;
import com.extendedclip.deluxemenus.libs.adventure.adventure.platform.bukkit.BukkitAudiences;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.Component;
import com.extendedclip.deluxemenus.listener.NewerPlayerListener;
import com.extendedclip.deluxemenus.listener.PlayerListener;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.metrics.Metrics;
import com.extendedclip.deluxemenus.nms.NMS;
import com.extendedclip.deluxemenus.persistentmeta.PersistentMetaHandler;
import com.extendedclip.deluxemenus.placeholder.Expansion;
import com.extendedclip.deluxemenus.updatechecker.UpdateChecker;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import com.extendedclip.deluxemenus.utils.Messages;
import com.extendedclip.deluxemenus.utils.VersionHelper;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class DeluxeMenus
extends JavaPlugin {
    private static DeluxeMenus instance;
    private static DebugLevel debugLevel;
    private DeluxeMenusConfig menuConfig;
    private NMS nms;
    private Map<String, ItemHook> itemHooks;
    private VaultHook vaultHook;
    private boolean checkUpdates;
    private ItemStack head;
    private PersistentMetaHandler persistentMetaHandler;
    private BukkitAudiences adventure;
    private final OfflinePlayerCache playerCache = new OfflinePlayerCache();
    public static final Map<String, Material> MATERIALS;

    public void onLoad() {
        this.nms = new NMS();
        instance = this;
        if (this.nms.setupAccessor()) {
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.INFO, "NMS hook has been setup successfully!");
            return;
        }
        DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Could not setup a NMS hook for your server version!");
    }

    public void onEnable() {
        if (!this.hookPlaceholderAPI()) {
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.SEVERE, "Could not hook into PlaceholderAPI!", "DeluxeMenus will now disable!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        DeluxeMenus.debug(DebugLevel.HIGHEST, Level.INFO, "Successfully hooked into PlaceholderAPI!");
        this.adventure = BukkitAudiences.create((Plugin)this);
        this.head = !VersionHelper.IS_ITEM_LEGACY ? new ItemStack(Material.PLAYER_HEAD, 1) : new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
        this.menuConfig = new DeluxeMenusConfig(this);
        if (this.menuConfig.loadDefConfig()) {
            DeluxeMenus.debugLevel(this.menuConfig.debugLevel());
            this.checkUpdates = this.getConfig().getBoolean("check_updates");
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.INFO, this.menuConfig.loadGUIMenus() + " GUI menus loaded!");
        } else {
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Failed to load from config.yml. Use /dm reload after fixing your errors.");
        }
        if (VersionHelper.IS_PDC_VERSION) {
            this.persistentMetaHandler = new PersistentMetaHandler();
        }
        new PlayerListener(this);
        new DeluxeMenusCommands(this);
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        if (this.checkUpdates) {
            UpdateChecker updateChecker = new UpdateChecker(this);
            if (updateChecker.updateAvailable()) {
                DeluxeMenus.debug(DebugLevel.HIGHEST, Level.INFO, "An update for DeluxeMenus (DeluxeMenus v" + updateChecker.getLatestVersion() + ")", "is available at https://www.spigotmc.org/resources/deluxemenus.11734/");
            } else {
                DeluxeMenus.debug(DebugLevel.HIGHEST, Level.INFO, "You are running the latest version of DeluxeMenus!");
            }
        }
        this.setupItemHooks();
        if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
            this.vaultHook = new VaultHook();
            if (this.vaultHook.hooked()) {
                DeluxeMenus.debug(DebugLevel.HIGHEST, Level.INFO, "Successfully hooked into Vault!");
            }
        }
        this.startMetrics();
        if (this.nms.isAvailable()) {
            new NewerPlayerListener(this);
        }
        new Expansion(this).register();
    }

    private void setupItemHooks() {
        this.itemHooks = new HashMap<String, ItemHook>();
        if (PlaceholderAPIPlugin.getServerVersion().isSpigot()) {
            this.itemHooks.put("basehead", new BaseHeadHook());
            this.itemHooks.put("texture", new TextureHeadHook());
        }
        if (Bukkit.getPluginManager().getPlugin("HeadDatabase") != null) {
            try {
                Class.forName("me.arcaniax.hdb.api.HeadDatabaseAPI");
                this.itemHooks.put("hdb", new HeadDatabaseHook());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (Bukkit.getPluginManager().getPlugin("ItemsAdder") != null) {
            this.itemHooks.put("itemsadder", new ItemsAdderHook());
        }
    }

    public ItemHook getItemHook(String id) {
        return this.itemHooks.get(id);
    }

    public ItemStack getHead() {
        return this.head != null ? this.head : new ItemStack(Material.DIRT, 1);
    }

    public static DeluxeMenus getInstance() {
        return instance;
    }

    public static DebugLevel debugLevel() {
        return debugLevel;
    }

    public static void debugLevel(DebugLevel level) {
        debugLevel = level;
    }

    public static DebugLevel printStacktraceLevel() {
        return DebugLevel.MEDIUM;
    }

    public static boolean shouldPrintStackTrace() {
        return DeluxeMenus.debugLevel().getPriority() <= DeluxeMenus.printStacktraceLevel().getPriority();
    }

    public static void printStacktrace(String message, Throwable throwable) {
        if (!DeluxeMenus.shouldPrintStackTrace()) {
            return;
        }
        DeluxeMenus.getInstance().getLogger().log(Level.SEVERE, message, throwable);
    }

    private void startMetrics() {
        Metrics metrics = new Metrics(this, 445);
        metrics.addCustomChart(new Metrics.SingleLineChart("menus", Menu::getLoadedMenuSize));
    }

    public void onDisable() {
        Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)this, "BungeeCord");
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        if (this.adventure != null) {
            this.adventure.close();
            this.adventure = null;
        }
        Menu.unloadForShutdown();
        this.itemHooks.clear();
        instance = null;
    }

    public void connect(Player p, String server) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        try {
            out.writeUTF("Connect");
            out.writeUTF(server);
        }
        catch (Exception e) {
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.SEVERE, "There was a problem attempting to send " + p.getName() + " to server " + server + "!");
            DeluxeMenus.printStacktrace("There was a problem attempting to send " + p.getName() + " to server " + server + "!", e);
        }
        p.sendPluginMessage((Plugin)this, "BungeeCord", out.toByteArray());
    }

    public void sms(CommandSender s, Component msg) {
        this.adventure().sender(s).sendMessage(msg);
    }

    public void sms(CommandSender s, Messages msg) {
        this.adventure().sender(s).sendMessage(msg.message());
    }

    public static void debug(@NotNull DebugLevel debugLevel, @NotNull Level level, String ... messages) {
        if (DeluxeMenus.debugLevel().getPriority() > debugLevel.getPriority()) {
            return;
        }
        DeluxeMenus.getInstance().getLogger().log(level, String.join((CharSequence)System.lineSeparator(), messages));
    }

    private boolean hookPlaceholderAPI() {
        return Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    public DeluxeMenusConfig getConfiguration() {
        return this.menuConfig;
    }

    public OfflinePlayerCache getPlayerCache() {
        return this.playerCache;
    }

    public NMS getNms() {
        return this.nms;
    }

    public VaultHook getVault() {
        return this.vaultHook;
    }

    public PersistentMetaHandler getPersistentMetaHandler() {
        return this.persistentMetaHandler;
    }

    public BukkitAudiences adventure() {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return this.adventure;
    }

    static {
        debugLevel = DebugLevel.LOWEST;
        MATERIALS = Arrays.stream(Material.values()).collect(Collectors.toUnmodifiableMap(Enum::name, Function.identity()));
    }
}

