/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.action;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.action.ActionType;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.Component;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.minimessage.MiniMessage;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.utils.AdventureUtils;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import com.extendedclip.deluxemenus.utils.ExpUtils;
import com.extendedclip.deluxemenus.utils.StringUtils;
import com.extendedclip.deluxemenus.utils.VersionHelper;
import java.util.Iterator;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class ClickActionTask
extends BukkitRunnable {
    private final DeluxeMenus plugin;
    private final String name;
    private final ActionType actionType;
    private final String exec;

    public ClickActionTask(@NotNull DeluxeMenus plugin, @NotNull String name, @NotNull ActionType actionType, @NotNull String exec) {
        this.plugin = plugin;
        this.name = name;
        this.actionType = actionType;
        this.exec = exec;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Player player = Bukkit.getServer().getPlayerExact(this.name);
        if (player == null) {
            return;
        }
        String executable = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)this.exec);
        MenuHolder holder = Menu.getMenuHolder(player);
        switch (this.actionType) {
            case META: {
                if (!VersionHelper.IS_PDC_VERSION || DeluxeMenus.getInstance().getPersistentMetaHandler() == null) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.INFO, "Meta action not supported on this server version.");
                    return;
                }
                try {
                    boolean result = DeluxeMenus.getInstance().getPersistentMetaHandler().setMeta(player, executable);
                    if (result) return;
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.INFO, "Invalid meta action! Make sure you have the right syntax.");
                    return;
                }
                catch (NumberFormatException exception) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.INFO, "Invalid integer value for meta action!");
                    return;
                }
            }
            case PLAYER: {
                player.chat("/" + executable);
                return;
            }
            case PLAYER_COMMAND_EVENT: {
                Bukkit.getPluginManager().callEvent((Event)new PlayerCommandPreprocessEvent(player, "/" + executable));
                return;
            }
            case PLACEHOLDER: {
                PlaceholderAPI.setPlaceholders((Player)player, (String)executable);
                return;
            }
            case CHAT: {
                player.chat(executable);
                return;
            }
            case CONSOLE: {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)executable);
                return;
            }
            case MINI_MESSAGE: {
                this.plugin.adventure().player(player).sendMessage((Component)MiniMessage.miniMessage().deserialize(executable));
                return;
            }
            case MINI_BROADCAST: {
                this.plugin.adventure().all().sendMessage((Component)MiniMessage.miniMessage().deserialize(executable));
                return;
            }
            case MESSAGE: {
                player.sendMessage(StringUtils.color(executable));
                return;
            }
            case BROADCAST: {
                Bukkit.broadcastMessage((String)StringUtils.color(executable));
                return;
            }
            case CLOSE: {
                Menu.closeMenu(player, true, true);
                return;
            }
            case OPEN_GUI_MENU: 
            case OPEN_MENU: {
                Menu menuToOpen = Menu.getMenu(executable);
                if (menuToOpen == null) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Could not find and open menu " + executable);
                    return;
                }
                if (holder == null) {
                    menuToOpen.openMenu(player);
                    return;
                }
                menuToOpen.openMenu(player, holder.getTypedArgs(), holder.getPlaceholderPlayer());
                return;
            }
            case CONNECT: {
                DeluxeMenus.getInstance().connect(player, executable);
                return;
            }
            case JSON_MESSAGE: {
                AdventureUtils.sendJson((CommandSender)player, executable);
                return;
            }
            case JSON_BROADCAST: 
            case BROADCAST_JSON: {
                this.plugin.adventure().all().sendMessage(AdventureUtils.fromJson(executable));
                return;
            }
            case REFRESH: {
                if (holder == null) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, player.getName() + " does not have menu open! Nothing to refresh!");
                    return;
                }
                holder.refreshMenu();
                return;
            }
            case TAKE_MONEY: {
                if (DeluxeMenus.getInstance().getVault() == null || !DeluxeMenus.getInstance().getVault().hooked()) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Vault not hooked! Cannot take money!");
                    return;
                }
                try {
                    DeluxeMenus.getInstance().getVault().takeMoney(player, Double.parseDouble(executable));
                    return;
                }
                catch (NumberFormatException exception) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Amount for take money action: " + executable + ", is not a valid number!");
                    return;
                }
            }
            case GIVE_MONEY: {
                if (DeluxeMenus.getInstance().getVault() == null || !DeluxeMenus.getInstance().getVault().hooked()) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Vault not hooked! Cannot give money!");
                    return;
                }
                try {
                    DeluxeMenus.getInstance().getVault().giveMoney(player, Double.parseDouble(executable));
                    return;
                }
                catch (NumberFormatException exception) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Amount for give money action: " + executable + ", is not a valid number!");
                    return;
                }
            }
            case TAKE_EXP: 
            case GIVE_EXP: {
                String lowerCaseExecutable = executable.toLowerCase();
                try {
                    if (Integer.parseInt(lowerCaseExecutable.replaceAll("l", "")) <= 0) {
                        return;
                    }
                    if (this.actionType == ActionType.TAKE_EXP) {
                        ExpUtils.setExp(player, "-" + lowerCaseExecutable);
                        return;
                    }
                    ExpUtils.setExp(player, lowerCaseExecutable);
                    return;
                }
                catch (NumberFormatException exception) {
                    if (this.actionType == ActionType.TAKE_EXP) {
                        DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Amount for take exp action: " + executable + ", is not a valid number!");
                        return;
                    }
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Amount for give exp action: " + executable + ", is not a valid number!");
                    return;
                }
            }
            case GIVE_PERM: {
                if (DeluxeMenus.getInstance().getVault() != null && DeluxeMenus.getInstance().getVault().hooked()) {
                    DeluxeMenus.getInstance().getVault().givePermission(player, executable);
                    return;
                }
                DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Vault not hooked! Cannot give permission: " + executable + "!");
                return;
            }
            case TAKE_PERM: {
                if (DeluxeMenus.getInstance().getVault() != null && DeluxeMenus.getInstance().getVault().hooked()) {
                    DeluxeMenus.getInstance().getVault().takePermission(player, executable);
                    return;
                }
                DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Vault not hooked! Cannot take permission: " + executable + "!");
                return;
            }
            case BROADCAST_SOUND: 
            case BROADCAST_WORLD_SOUND: 
            case PLAY_SOUND: {
                Sound sound;
                float volume = 1.0f;
                float pitch = 1.0f;
                if (!executable.contains(" ")) {
                    try {
                        sound = Sound.valueOf((String)executable.toUpperCase());
                    }
                    catch (IllegalArgumentException exception) {
                        DeluxeMenus.printStacktrace("Sound name given for sound action: " + executable + ", is not a valid sound!", exception);
                        return;
                    }
                }
                String[] parts = executable.split(" ", 3);
                try {
                    sound = Sound.valueOf((String)parts[0].toUpperCase());
                }
                catch (IllegalArgumentException exception) {
                    DeluxeMenus.printStacktrace("Sound name given for sound action: " + parts[0] + ", is not a valid sound!", exception);
                    return;
                }
                if (parts.length == 3) {
                    try {
                        pitch = Float.parseFloat(parts[2]);
                    }
                    catch (NumberFormatException exception) {
                        DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Pitch given for sound action: " + parts[2] + ", is not a valid number!");
                        DeluxeMenus.printStacktrace("Pitch given for sound action: " + parts[2] + ", is not a valid number!", exception);
                    }
                }
                try {
                    volume = Float.parseFloat(parts[1]);
                }
                catch (NumberFormatException exception) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Volume given for sound action: " + parts[1] + ", is not a valid number!");
                    DeluxeMenus.printStacktrace("Volume given for sound action: " + parts[1] + ", is not a valid number!", exception);
                }
                switch (this.actionType) {
                    case BROADCAST_SOUND: {
                        Player target;
                        Iterator iterator = Bukkit.getOnlinePlayers().iterator();
                        while (iterator.hasNext()) {
                            target = (Player)iterator.next();
                            target.playSound(target.getLocation(), sound, volume, pitch);
                        }
                        return;
                    }
                    case BROADCAST_WORLD_SOUND: {
                        Player target;
                        Iterator iterator = player.getWorld().getPlayers().iterator();
                        while (iterator.hasNext()) {
                            target = (Player)iterator.next();
                            target.playSound(target.getLocation(), sound, volume, pitch);
                        }
                        return;
                    }
                    case PLAY_SOUND: {
                        player.playSound(player.getLocation(), sound, volume, pitch);
                    }
                }
                return;
            }
        }
    }
}

