/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.listener;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.menu.MenuItem;
import com.extendedclip.deluxemenus.nms.NmsAccessor;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    private final DeluxeMenus plugin;
    private final Cache<UUID, Long> cache = CacheBuilder.newBuilder().expireAfterWrite(75L, TimeUnit.MILLISECONDS).build();
    private final Cache<UUID, Long> shiftCache = CacheBuilder.newBuilder().expireAfterWrite(200L, TimeUnit.MILLISECONDS).build();

    public PlayerListener(DeluxeMenus plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onCommandExecute(PlayerCommandPreprocessEvent event) {
        String cmd = event.getMessage().substring(1);
        Menu menu = Menu.getMenuByCommand(cmd.toLowerCase());
        if (menu == null) {
            return;
        }
        if (menu.registersCommand()) {
            return;
        }
        Player player = event.getPlayer();
        menu.openMenu(player);
        event.setCancelled(true);
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (Menu.inMenu(player)) {
            Menu.closeMenu(player, false);
        }
    }

    @EventHandler
    public void onOpen(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (player.isSleeping()) {
            event.setCancelled(true);
        }
        if (Menu.inMenu(player)) {
            Menu.closeMenu(player, true);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        if (DeluxeMenus.getInstance().getNms().isAvailable() && DeluxeMenus.getInstance().getNms().getAccessor().hasTag(event.getItemDrop().getItemStack(), "DM")) {
            event.getItemDrop().remove();
        }
    }

    @EventHandler
    public void onLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        if (!DeluxeMenus.getInstance().getNms().isAvailable()) {
            return;
        }
        NmsAccessor accessor = DeluxeMenus.getInstance().getNms().getAccessor();
        Bukkit.getScheduler().runTaskLater((Plugin)DeluxeMenus.getInstance(), () -> {
            for (ItemStack itemStack : player.getInventory().getContents()) {
                if (itemStack == null || !accessor.hasTag(itemStack, "DM")) continue;
                player.getInventory().remove(itemStack);
            }
        }, 10L);
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (Menu.inMenu(player)) {
            Menu.closeMenu(player, false);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                Menu.cleanInventory(player);
                player.updateInventory();
            }, 3L);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        MenuHolder holder = Menu.getMenuHolder(player);
        if (holder == null) {
            return;
        }
        if (holder.getMenu() == null) {
            Menu.closeMenu(player, true);
        }
        if (holder.isUpdating()) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        MenuItem item = holder.getItem(slot);
        if (item == null) {
            return;
        }
        if (this.cache.getIfPresent((Object)player.getUniqueId()) != null) {
            return;
        }
        if (this.shiftCache.getIfPresent((Object)player.getUniqueId()) != null) {
            return;
        }
        if (event.getClick() == ClickType.DOUBLE_CLICK) {
            return;
        }
        if (event.getClick() == ClickType.SHIFT_LEFT) {
            this.shiftCache.put((Object)player.getUniqueId(), (Object)System.currentTimeMillis());
        }
        if (item.getClickHandler() != null) {
            if (item.getClickRequirements() != null && !item.getClickRequirements().evaluate(holder)) {
                if (item.getClickRequirements().getDenyHandler() != null) {
                    item.getClickRequirements().getDenyHandler().onClick(holder);
                }
                return;
            }
            this.cache.put((Object)player.getUniqueId(), (Object)System.currentTimeMillis());
            item.getClickHandler().onClick(holder);
            return;
        }
        if (event.isShiftClick() && event.isLeftClick() && item.getShiftLeftClickHandler() != null) {
            if (item.getShiftLeftClickRequirements() != null && !item.getShiftLeftClickRequirements().evaluate(holder)) {
                if (item.getShiftLeftClickRequirements().getDenyHandler() != null) {
                    item.getShiftLeftClickRequirements().getDenyHandler().onClick(holder);
                }
                return;
            }
            this.cache.put((Object)player.getUniqueId(), (Object)System.currentTimeMillis());
            item.getShiftLeftClickHandler().onClick(holder);
        } else if (event.isShiftClick() && event.isRightClick() && item.getShiftRightClickHandler() != null) {
            if (item.getShiftRightClickRequirements() != null && !item.getShiftRightClickRequirements().evaluate(holder)) {
                if (item.getShiftRightClickRequirements().getDenyHandler() != null) {
                    item.getShiftRightClickRequirements().getDenyHandler().onClick(holder);
                }
                return;
            }
            this.cache.put((Object)player.getUniqueId(), (Object)System.currentTimeMillis());
            item.getShiftRightClickHandler().onClick(holder);
        } else if (event.getClick() == ClickType.LEFT && item.getLeftClickHandler() != null) {
            if (item.getLeftClickRequirements() != null && !item.getLeftClickRequirements().evaluate(holder)) {
                if (item.getLeftClickRequirements().getDenyHandler() != null) {
                    item.getLeftClickRequirements().getDenyHandler().onClick(holder);
                }
                return;
            }
            this.cache.put((Object)player.getUniqueId(), (Object)System.currentTimeMillis());
            item.getLeftClickHandler().onClick(holder);
        } else if (event.getClick() == ClickType.RIGHT && item.getRightClickHandler() != null) {
            if (item.getRightClickRequirements() != null && !item.getRightClickRequirements().evaluate(holder)) {
                if (item.getRightClickRequirements().getDenyHandler() != null) {
                    item.getRightClickRequirements().getDenyHandler().onClick(holder);
                }
                return;
            }
            this.cache.put((Object)player.getUniqueId(), (Object)System.currentTimeMillis());
            item.getRightClickHandler().onClick(holder);
        } else if (event.getClick() == ClickType.MIDDLE && item.getMiddleClickHandler() != null) {
            if (item.getMiddleClickRequirements() != null && !item.getMiddleClickRequirements().evaluate(holder)) {
                if (item.getMiddleClickRequirements().getDenyHandler() != null) {
                    item.getMiddleClickRequirements().getDenyHandler().onClick(holder);
                }
                return;
            }
            this.cache.put((Object)player.getUniqueId(), (Object)System.currentTimeMillis());
            item.getMiddleClickHandler().onClick(holder);
        }
    }
}

