/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.menu;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.action.ClickHandler;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.menu.MenuItem;
import com.extendedclip.deluxemenus.requirement.RequirementList;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import com.extendedclip.deluxemenus.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import me.clip.placeholderapi.util.Msg;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Menu
extends Command {
    private static final Map<String, Menu> menus = new HashMap<String, Menu>();
    private static final Set<MenuHolder> holders = new HashSet<MenuHolder>();
    private static CommandMap commandMap = null;
    private final String menuName;
    private final String menuTitle;
    private final int size;
    private final Map<Integer, TreeMap<Integer, MenuItem>> items;
    private InventoryType type;
    private List<String> menuCommands;
    private int updateInterval;
    private RequirementList openRequirements;
    private ClickHandler openHandler;
    private ClickHandler closeHandler;
    private boolean registersCommand;
    private List<String> args;
    private String argUsageMessage;

    public Menu(String menuName, String menuTitle, Map<Integer, TreeMap<Integer, MenuItem>> items, int size, List<String> menuCommands, boolean registerCommand, List<String> args) {
        super(menuCommands.get(0));
        this.menuName = menuName;
        this.menuTitle = StringUtils.color(menuTitle);
        this.items = items;
        this.size = size;
        this.menuCommands = menuCommands;
        this.registersCommand = registerCommand;
        this.args = args;
        if (registerCommand) {
            if (menuCommands.size() > 1) {
                this.setAliases(menuCommands.subList(1, menuCommands.size()));
            }
            this.addCommand();
        }
        menus.put(this.menuName, this);
    }

    public Menu(String menuName, String menuTitle, Map<Integer, TreeMap<Integer, MenuItem>> items, int size) {
        super(menuName);
        this.menuName = menuName;
        this.menuTitle = StringUtils.color(menuTitle);
        this.items = items;
        this.size = size;
        menus.put(this.menuName, this);
    }

    public static void unload(String menu) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!Menu.inMenu(p, menu)) continue;
            Menu.closeMenu(p, true);
        }
        Menu m = Menu.getMenu(menu);
        if (m == null) {
            return;
        }
        m.removeCommand();
        menus.remove(menu);
    }

    public static void unload() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!Menu.inMenu(p)) continue;
            Menu.closeMenu(p, true);
        }
        if (Menu.getAllMenus() != null) {
            for (Menu menu : Menu.getAllMenus()) {
                menu.removeCommand();
            }
        }
        menus.clear();
        holders.clear();
    }

    public static void unloadForShutdown() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!Menu.inMenu(player)) continue;
            Menu.closeMenuForShutdown(player);
        }
        menus.clear();
    }

    public static int getLoadedMenuSize() {
        return menus.size();
    }

    public static Menu getMenu(Player p) {
        return Menu.getOpenMenu(p);
    }

    public static Collection<Menu> getAllMenus() {
        return !menus.isEmpty() ? menus.values() : null;
    }

    public static Menu getMenu(String menuName) {
        for (Map.Entry<String, Menu> e : menus.entrySet()) {
            if (!e.getKey().equalsIgnoreCase(menuName)) continue;
            return e.getValue();
        }
        return null;
    }

    public static Menu getMenuByCommand(String command) {
        for (Menu m : menus.values()) {
            if (m.getMenuCommandUsed(command) == null) continue;
            return m;
        }
        return null;
    }

    public static boolean isMenuCommand(String command) {
        return Menu.getMenuByCommand(command) != null;
    }

    public static boolean inMenu(Player p) {
        return holders.stream().anyMatch(h -> h.getViewerName().equals(p.getName()));
    }

    public static boolean inMenu(Player p, String menu) {
        return holders.stream().anyMatch(h -> h.getMenuName().equals(menu) && h.getViewerName().equals(p.getName()));
    }

    public static MenuHolder getMenuHolder(Player p) {
        return holders.stream().filter(h -> h.getViewerName().equals(p.getName())).findFirst().orElse(null);
    }

    public static Menu getOpenMenu(Player p) {
        MenuHolder h = Menu.getMenuHolder(p);
        return h == null ? null : h.getMenu();
    }

    public static void cleanInventory(Player p) {
        if (p == null) {
            return;
        }
        if (DeluxeMenus.getInstance().getNms().isAvailable()) {
            for (ItemStack i : p.getInventory().getContents()) {
                if (i == null || !DeluxeMenus.getInstance().getNms().getAccessor().hasTag(i, "DM")) continue;
                p.getInventory().remove(i);
            }
        }
        p.updateInventory();
    }

    public static void closeMenu(Player p, boolean close, boolean executeCloseActions) {
        MenuHolder holder = Menu.getMenuHolder(p);
        if (holder == null) {
            return;
        }
        holder.stopPlaceholderUpdate();
        if (executeCloseActions && holder.getMenu().getCloseHandler() != null) {
            holder.getMenu().getCloseHandler().onClick(holder);
        }
        if (close) {
            Bukkit.getScheduler().runTask((Plugin)DeluxeMenus.getInstance(), () -> {
                p.closeInventory();
                Menu.cleanInventory(p);
            });
        }
        holders.remove(holder);
    }

    public static void closeMenuForShutdown(Player p) {
        MenuHolder holder = Menu.getMenuHolder(p);
        if (holder == null) {
            return;
        }
        holder.stopPlaceholderUpdate();
        p.closeInventory();
        Menu.cleanInventory(p);
    }

    public static void closeMenu(Player p, boolean close) {
        Menu.closeMenu(p, close, false);
    }

    private void addCommand() {
        boolean registered;
        if (commandMap == null) {
            try {
                Field f = Bukkit.getServer().getClass().getDeclaredField("commandMap");
                f.setAccessible(true);
                commandMap = (CommandMap)f.get(Bukkit.getServer());
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (registered = commandMap.register("DeluxeMenus", (Command)this)) {
            DeluxeMenus.debug(DebugLevel.LOW, Level.INFO, "Registered command: " + this.getName() + " for menu: " + this.getMenuName());
        }
    }

    private void removeCommand() {
        if (commandMap != null && this.registersCommand()) {
            try {
                Field cMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
                cMap.setAccessible(true);
                Field knownCommands = SimpleCommandMap.class.getDeclaredField("knownCommands");
                knownCommands.setAccessible(true);
                ((Map)knownCommands.get((SimpleCommandMap)cMap.get(Bukkit.getServer()))).remove(this.getName());
                boolean unregistered = this.unregister((CommandMap)cMap.get(Bukkit.getServer()));
                this.unregister(commandMap);
                if (unregistered) {
                    DeluxeMenus.debug(DebugLevel.HIGH, Level.INFO, "Successfully unregistered command: " + this.getName());
                } else {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Failed to unregister command: " + this.getName());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] typedArgs) {
        if (!(sender instanceof Player)) {
            Msg.msg((CommandSender)sender, (String[])new String[]{"Menus can only be opened by players!"});
            return true;
        }
        HashMap<String, String> argMap = null;
        if (this.args != null) {
            if (typedArgs.length < this.args.size()) {
                if (this.argUsageMessage != null) {
                    Msg.msg((CommandSender)sender, (String[])new String[]{this.argUsageMessage});
                }
                return true;
            }
            argMap = new HashMap<String, String>();
            int index = 0;
            for (String arg : this.args) {
                if (index + 1 == this.args.size()) {
                    String last = String.join((CharSequence)" ", Arrays.asList(typedArgs).subList(index, typedArgs.length));
                    argMap.put(arg, last);
                } else {
                    argMap.put(arg, typedArgs[index]);
                }
                ++index;
            }
        }
        Player player = (Player)sender;
        this.openMenu(player, argMap, null);
        return true;
    }

    private boolean hasOpenBypassPerm(Player viewer) {
        return viewer.hasPermission("deluxemenus.openrequirement.bypass." + this.menuName) || viewer.hasPermission("deluxemenus.openrequirement.bypass.*");
    }

    private boolean handleOpenRequirements(MenuHolder holder) {
        if (this.openRequirements == null || this.openRequirements.getRequirements() == null) {
            return true;
        }
        if (holder.getViewer() != null && this.hasOpenBypassPerm(holder.getViewer())) {
            return true;
        }
        if (!this.openRequirements.evaluate(holder)) {
            if (this.openRequirements.getDenyHandler() != null) {
                this.openRequirements.getDenyHandler().onClick(holder);
            }
            return false;
        }
        return true;
    }

    public void openMenu(Player viewer) {
        this.openMenu(viewer, null, null);
    }

    public void openMenu(Player viewer, Map<String, String> args, Player placeholderPlayer) {
        if (this.menuTitle == null || this.items == null || this.items.size() <= 0) {
            return;
        }
        MenuHolder holder = new MenuHolder(viewer);
        if (placeholderPlayer != null) {
            holder.setPlaceholderPlayer(placeholderPlayer);
        }
        holder.setTypedArgs(args);
        if (!this.handleOpenRequirements(holder)) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)DeluxeMenus.getInstance(), () -> {
            HashSet<MenuItem> activeItems = new HashSet<MenuItem>();
            block0: for (Map.Entry<Integer, TreeMap<Integer, MenuItem>> entry : this.items.entrySet()) {
                for (MenuItem menuItem : entry.getValue().values()) {
                    int slot = menuItem.getSlot();
                    if (slot >= this.size) {
                        DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Item set to slot " + slot + " for menu: " + this.menuName + " exceeds the inventory size!", "This item will not be added to the menu!");
                        continue;
                    }
                    if (menuItem.hasViewRequirement()) {
                        if (!menuItem.getViewRequirements().evaluate(holder)) continue;
                        activeItems.add(menuItem);
                        continue block0;
                    }
                    activeItems.add(menuItem);
                    continue block0;
                }
            }
            if (activeItems.isEmpty()) {
                return;
            }
            holder.setMenuName(this.menuName);
            holder.setActiveItems(activeItems);
            if (this.openHandler != null) {
                this.openHandler.onClick(holder);
            }
            String title = StringUtils.color(holder.setPlaceholders(this.menuTitle));
            Inventory inventory = this.type != null ? Bukkit.createInventory((InventoryHolder)holder, (InventoryType)this.type, (String)title) : Bukkit.createInventory((InventoryHolder)holder, (int)this.size, (String)title);
            holder.setInventory(inventory);
            boolean update = false;
            for (MenuItem item : activeItems) {
                int slot;
                ItemStack iStack = item.getItemStack(holder);
                if (iStack == null) continue;
                if (DeluxeMenus.getInstance().getNms().isAvailable()) {
                    iStack = DeluxeMenus.getInstance().getNms().getAccessor().setTag(iStack, "DM");
                }
                if ((slot = item.getSlot()) >= this.size) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Item set to slot " + slot + " for menu: " + this.menuName + " exceeds the inventory size!", "This item will not be added to the menu!");
                    continue;
                }
                if (item.updatePlaceholders()) {
                    update = true;
                }
                inventory.setItem(item.getSlot(), iStack);
            }
            boolean bl = update;
            Bukkit.getScheduler().runTask((Plugin)DeluxeMenus.getInstance(), () -> {
                if (Menu.inMenu(holder.getViewer())) {
                    Menu.closeMenu(holder.getViewer(), false);
                }
                viewer.openInventory(inventory);
                holders.add(holder);
                if (updatePlaceholders) {
                    holder.startUpdatePlaceholdersTask();
                }
            });
        });
    }

    public String getMenuTitle() {
        return this.menuTitle;
    }

    public String getMenuName() {
        return this.menuName;
    }

    public List<String> getMenuCommands() {
        return this.menuCommands;
    }

    public Map<Integer, TreeMap<Integer, MenuItem>> getMenuItems() {
        return this.items;
    }

    public int getSize() {
        return this.size;
    }

    public int getUpdateInterval() {
        return this.updateInterval >= 1 ? this.updateInterval : 10;
    }

    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    public String getMenuCommandUsed(String command) {
        if (this.getMenuCommands() == null) {
            return null;
        }
        for (String c : this.getMenuCommands()) {
            if (!command.equalsIgnoreCase(c)) continue;
            return c;
        }
        return null;
    }

    public RequirementList getOpenRequirements() {
        return this.openRequirements;
    }

    public void setOpenRequirements(RequirementList openRequirements) {
        this.openRequirements = openRequirements;
    }

    public InventoryType getInventoryType() {
        return this.type;
    }

    public void setInventoryType(InventoryType type) {
        this.type = type;
    }

    public ClickHandler getOpenHandler() {
        return this.openHandler;
    }

    public void setOpenHandler(ClickHandler openHandler) {
        this.openHandler = openHandler;
    }

    public ClickHandler getCloseHandler() {
        return this.closeHandler;
    }

    public void setCloseHandler(ClickHandler closeHandler) {
        this.closeHandler = closeHandler;
    }

    public boolean registersCommand() {
        return this.registersCommand;
    }

    public String getArgUsageMessage() {
        return this.argUsageMessage;
    }

    public void setArgUsageMessage(String argUsageMessage) {
        this.argUsageMessage = argUsageMessage;
    }
}

