/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.requirement;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.requirement.Requirement;
import com.extendedclip.deluxemenus.utils.ExpUtils;

public class HasExpRequirement
extends Requirement {
    private final boolean invert;
    private final boolean level;
    private final String amt;

    public HasExpRequirement(String amt, boolean invert, boolean level) {
        this.amt = amt;
        this.invert = invert;
        this.level = level;
    }

    @Override
    public boolean evaluate(MenuHolder holder) {
        int amount;
        int has = this.level ? holder.getViewer().getLevel() : ExpUtils.getTotalExperience(holder.getViewer());
        try {
            amount = Integer.parseInt(holder.setPlaceholders(this.amt));
        }
        catch (Exception exception) {
            DeluxeMenus.printStacktrace("Invalid amount found for has exp requirement: " + holder.setPlaceholders(this.amt), exception);
            return false;
        }
        if (has < amount) {
            return this.invert;
        }
        return !this.invert;
    }
}

