/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.requirement;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.requirement.Requirement;
import com.extendedclip.deluxemenus.requirement.wrappers.ItemWrapper;
import com.extendedclip.deluxemenus.utils.StringUtils;
import com.extendedclip.deluxemenus.utils.VersionHelper;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class HasItemRequirement
extends Requirement {
    private final ItemWrapper wrapper;
    private final boolean invert;

    public HasItemRequirement(ItemWrapper wrapper, boolean invert) {
        this.wrapper = wrapper;
        this.invert = invert;
    }

    @Override
    public boolean evaluate(MenuHolder holder) {
        String materialName = holder.setPlaceholders(this.wrapper.getMaterial()).toUpperCase();
        Material material = DeluxeMenus.MATERIALS.get(materialName);
        if (material == null) {
            return this.invert;
        }
        if (material == Material.AIR) {
            return this.invert == (holder.getViewer().getInventory().firstEmpty() == -1);
        }
        ItemStack[] armor = this.wrapper.checkArmor() ? holder.getViewer().getInventory().getArmorContents() : null;
        ItemStack[] offHand = this.wrapper.checkOffhand() ? holder.getViewer().getInventory().getExtraContents() : null;
        ItemStack[] inventory = holder.getViewer().getInventory().getStorageContents();
        int total = 0;
        for (ItemStack itemToCheck : inventory) {
            if (!this.isRequiredItem(itemToCheck, holder, material)) continue;
            total += itemToCheck.getAmount();
        }
        if (offHand != null) {
            for (ItemStack itemToCheck : offHand) {
                if (!this.isRequiredItem(itemToCheck, holder, material)) continue;
                total += itemToCheck.getAmount();
            }
        }
        if (armor != null) {
            for (ItemStack itemToCheck : armor) {
                if (!this.isRequiredItem(itemToCheck, holder, material)) continue;
                total += itemToCheck.getAmount();
            }
        }
        return this.invert == total < this.wrapper.getAmount();
    }

    private boolean isRequiredItem(ItemStack itemToCheck, MenuHolder holder, Material material) {
        if (itemToCheck == null || itemToCheck.getType() == Material.AIR) {
            return false;
        }
        if (this.wrapper.getMaterial() != null && itemToCheck.getType() != material) {
            return false;
        }
        if (this.wrapper.hasData() && itemToCheck.getDurability() != this.wrapper.getData()) {
            return false;
        }
        ItemMeta metaToCheck = itemToCheck.getItemMeta();
        if (this.wrapper.isStrict()) {
            if (metaToCheck != null) {
                if (VersionHelper.IS_CUSTOM_MODEL_DATA && metaToCheck.hasCustomModelData()) {
                    return false;
                }
                if (metaToCheck.hasLore()) {
                    return false;
                }
                return !metaToCheck.hasDisplayName();
            }
        } else {
            String loreToCheck;
            String lore;
            List loreX;
            if ((this.wrapper.getCustomData() != 0 || this.wrapper.getName() != null || this.wrapper.getLore() != null) && metaToCheck == null) {
                return false;
            }
            if (this.wrapper.getCustomData() != 0 && VersionHelper.IS_CUSTOM_MODEL_DATA) {
                if (!metaToCheck.hasCustomModelData()) {
                    return false;
                }
                if (metaToCheck.getCustomModelData() != this.wrapper.getCustomData()) {
                    return false;
                }
            }
            if (this.wrapper.getName() != null) {
                if (!metaToCheck.hasDisplayName()) {
                    return false;
                }
                String name = StringUtils.color(holder.setPlaceholders(this.wrapper.getName()));
                String nameToCheck = StringUtils.color(holder.setPlaceholders(metaToCheck.getDisplayName()));
                if (this.wrapper.checkNameContains() && this.wrapper.checkNameIgnoreCase() ? !org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)nameToCheck, (CharSequence)name) : (this.wrapper.checkNameContains() ? !nameToCheck.contains(name) : (this.wrapper.checkNameIgnoreCase() ? !nameToCheck.equalsIgnoreCase(name) : !nameToCheck.equals(name)))) {
                    return false;
                }
            }
            if (this.wrapper.getLoreList() != null) {
                loreX = metaToCheck.getLore();
                if (loreX == null) {
                    return false;
                }
                lore = this.wrapper.getLoreList().stream().map(holder::setPlaceholders).map(StringUtils::color).collect(Collectors.joining("&&"));
                loreToCheck = loreX.stream().map(holder::setPlaceholders).map(StringUtils::color).collect(Collectors.joining("&&"));
                if (this.wrapper.checkLoreContains() && this.wrapper.checkLoreIgnoreCase() ? !org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)loreToCheck, (CharSequence)lore) : (this.wrapper.checkLoreContains() ? !loreToCheck.contains(lore) : (this.wrapper.checkLoreIgnoreCase() ? !loreToCheck.equalsIgnoreCase(lore) : !loreToCheck.equals(lore)))) {
                    return false;
                }
            }
            if (this.wrapper.getLore() != null) {
                loreX = metaToCheck.getLore();
                if (loreX == null) {
                    return false;
                }
                lore = StringUtils.color(holder.setPlaceholders(this.wrapper.getLore()));
                loreToCheck = loreX.stream().map(holder::setPlaceholders).map(StringUtils::color).collect(Collectors.joining("&&"));
                if (this.wrapper.checkLoreContains() && this.wrapper.checkLoreIgnoreCase()) {
                    return org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)loreToCheck, (CharSequence)lore);
                }
                if (this.wrapper.checkLoreContains()) {
                    return loreToCheck.contains(lore);
                }
                if (this.wrapper.checkLoreIgnoreCase()) {
                    return loreToCheck.equalsIgnoreCase(lore);
                }
                return loreToCheck.equals(lore);
            }
        }
        return true;
    }
}

