/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.requirement;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.requirement.Requirement;

public class HasMoneyRequirement
extends Requirement {
    private final boolean invert;
    private final String placeholder;
    private double amount;

    public HasMoneyRequirement(double amount, boolean invert, String placeholder) {
        this.amount = amount;
        this.invert = invert;
        this.placeholder = placeholder;
    }

    @Override
    public boolean evaluate(MenuHolder holder) {
        if (this.getInstance().getVault() == null) {
            return false;
        }
        if (this.placeholder != null) {
            try {
                String expected = holder.setPlaceholders(this.placeholder);
                this.amount = Double.parseDouble(expected);
            }
            catch (NumberFormatException exception) {
                DeluxeMenus.printStacktrace("Invalid amount found for has money requirement: " + holder.setPlaceholders(this.placeholder), exception);
            }
        }
        if (this.invert) {
            return !this.getInstance().getVault().hasEnough(holder.getViewer(), this.amount);
        }
        return this.getInstance().getVault().hasEnough(holder.getViewer(), this.amount);
    }
}

