/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.mastercooldowns;

import me.gabytm.mastercooldowns.PlaceholderAPIHook;
import me.gabytm.mastercooldowns.api.MasterCooldownsAPI;
import me.gabytm.mastercooldowns.commands.AddCooldownCommand;
import me.gabytm.mastercooldowns.commands.CheckCooldownCommand;
import me.gabytm.mastercooldowns.commands.ListCooldownsCommand;
import me.gabytm.mastercooldowns.commands.MasterCooldownsCommand;
import me.gabytm.mastercooldowns.commands.ReloadCommand;
import me.gabytm.mastercooldowns.commands.RemoveCooldownCommand;
import me.gabytm.mastercooldowns.cooldown.CooldownManager;
import me.gabytm.mastercooldowns.database.DatabaseManager;
import me.gabytm.mastercooldowns.libs.bstats.bukkit.Metrics;
import me.gabytm.mastercooldowns.libs.commands.base.CommandBase;
import me.gabytm.mastercooldowns.libs.commands.base.CommandManager;
import me.gabytm.mastercooldowns.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import me.gabytm.mastercooldowns.utils.Messages;
import me.gabytm.mastercooldowns.utils.StringUtil;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public final class MasterCooldowns
extends JavaPlugin {
    private CooldownManager cooldownManager;
    private DatabaseManager databaseManager;
    private BukkitAudiences audiences;

    public void onEnable() {
        new Metrics(this, 5794);
        CommandManager commandManager = new CommandManager((Plugin)this);
        this.cooldownManager = new CooldownManager();
        this.databaseManager = new DatabaseManager(this);
        this.audiences = BukkitAudiences.create((Plugin)this);
        this.saveDefaultConfig();
        this.databaseManager.connect();
        commandManager.register((CommandBase)new MasterCooldownsCommand(this));
        commandManager.register((CommandBase)new AddCooldownCommand(this));
        commandManager.register((CommandBase)new CheckCooldownCommand(this));
        commandManager.register((CommandBase)new ListCooldownsCommand(this));
        commandManager.register((CommandBase)new ReloadCommand(this));
        commandManager.register((CommandBase)new RemoveCooldownCommand(this));
        commandManager.getMessageHandler().register("cmd.no.permission", sender -> sender.sendMessage(Messages.NO_PERMISSION.value()));
        commandManager.getMessageHandler().register("cmd.wrong.usage", sender -> sender.sendMessage(Messages.INCORRECT_USAGE.value()));
        commandManager.getMessageHandler().register("cmd.no.exists", sender -> sender.sendMessage(Messages.UNKNOWN_COMMAND.value()));
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderAPIHook(this).register();
            StringUtil.infoLog(this, "&aPlaceholderAPI hook enabled.");
        }
        this.getServer().getServicesManager().register(MasterCooldownsAPI.class, (Object)new MasterCooldownsAPI(this), (Plugin)this, ServicePriority.Highest);
    }

    public void onDisable() {
        this.databaseManager.saveCooldowns(this.getCooldownManager().getLoadedCooldowns());
        HandlerList.unregisterAll((Plugin)this);
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public BukkitAudiences getAudiences() {
        return this.audiences;
    }
}

