/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.mastercooldowns;

import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.gabytm.mastercooldowns.MasterCooldowns;
import me.gabytm.mastercooldowns.cooldown.Cooldown;
import me.gabytm.mastercooldowns.cooldown.CooldownManager;
import me.gabytm.mastercooldowns.utils.TimeUtil;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderAPIHook
extends PlaceholderExpansion {
    private final MasterCooldowns plugin;

    public PlaceholderAPIHook(MasterCooldowns plugin) {
        this.plugin = plugin;
    }

    private @NotNull Stream<@Nullable Cooldown> getCooldowns(@NotNull UUID uuid, @NotNull String list) {
        return Arrays.stream(list.split(" ")).map(it -> this.plugin.getCooldownManager().getCooldownByName(uuid, (String)it));
    }

    @NotNull
    private String bool(boolean bool) {
        return this.plugin.getConfig().getString("placeholders.boolean." + bool, Boolean.toString(bool));
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", this.plugin.getDescription().getAuthors());
    }

    @NotNull
    public String getIdentifier() {
        return "mcd";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer p, String param) {
        CooldownManager cooldownManager = this.plugin.getCooldownManager();
        if (param.toLowerCase().startsWith("left_formatted_")) {
            String name = param.toLowerCase().split("left_formatted_")[1];
            Cooldown cooldown = cooldownManager.getCooldownByName(p.getUniqueId(), name);
            if (cooldown != null && !cooldown.isExpired()) {
                long left = TimeUnit.SECONDS.toMillis(cooldown.getExpiration()) - System.currentTimeMillis();
                return TimeUtil.format(TimeUnit.MILLISECONDS.toSeconds(left));
            }
            return this.plugin.getConfig().getString("placeholders.formatted.empty", "");
        }
        if (param.toLowerCase().startsWith("left_")) {
            String name = param.toLowerCase().split("left_")[1];
            Cooldown cooldown = cooldownManager.getCooldownByName(p.getUniqueId(), name);
            if (cooldown != null && !cooldown.isExpired()) {
                return String.valueOf(cooldown.getTimeLeft());
            }
            return this.plugin.getConfig().getString("placeholders.empty", "");
        }
        if (param.startsWith("active_")) {
            long count = this.getCooldowns(p.getUniqueId(), param.replace("active_", "")).filter(Objects::nonNull).filter(it -> !it.isExpired()).count();
            return String.valueOf(count);
        }
        if (param.startsWith("inactive_")) {
            long count = this.getCooldowns(p.getUniqueId(), param.replace("inactive_", "")).filter(it -> it == null || it.isExpired()).count();
            return String.valueOf(count);
        }
        if (param.startsWith("isactive_")) {
            Cooldown cooldown = cooldownManager.getCooldownByName(p.getUniqueId(), param.replace("isactive_", ""));
            return this.bool(cooldown != null && !cooldown.isExpired());
        }
        if (param.startsWith("isinactive_")) {
            Cooldown cooldown = cooldownManager.getCooldownByName(p.getUniqueId(), param.replace("isinactive_", ""));
            return this.bool(cooldown == null || cooldown.isExpired());
        }
        return null;
    }
}

