/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.mastercooldowns.api;

import com.google.common.collect.Table;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import me.gabytm.mastercooldowns.MasterCooldowns;
import me.gabytm.mastercooldowns.cooldown.Cooldown;
import org.jetbrains.annotations.NotNull;

public class MasterCooldownsAPI {
    private final MasterCooldowns plugin;

    public MasterCooldownsAPI(@NotNull MasterCooldowns plugin) {
        this.plugin = plugin;
    }

    public void addCooldown(@NotNull Cooldown cooldown) {
        this.plugin.getCooldownManager().addCooldown(cooldown);
    }

    public void addCooldown(@NotNull UUID uuid, @NotNull String name, long start, long expiration) {
        this.plugin.getCooldownManager().addCooldown(uuid, name, start, expiration);
    }

    public void removeCooldown(@NotNull Cooldown cooldown) {
        this.plugin.getCooldownManager().removeCooldown(cooldown);
    }

    public void removeCooldown(@NotNull UUID uuid, @NotNull String name) {
        this.plugin.getCooldownManager().removeCooldown(uuid, name);
    }

    @NotNull
    public Collection<Cooldown> getPlayerCooldowns(@NotNull UUID uuid) {
        return this.plugin.getCooldownManager().getPlayerCooldowns(uuid);
    }

    @NotNull
    public List<Cooldown> getPlayerActiveCooldowns(@NotNull UUID uuid) {
        return this.plugin.getCooldownManager().getPlayerActiveCooldowns(uuid);
    }

    @NotNull
    public Table<UUID, String, Cooldown> getLoadedCooldowns() {
        return this.plugin.getCooldownManager().getLoadedCooldowns();
    }
}

