/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.mastercooldowns.commands;

import java.util.concurrent.TimeUnit;
import me.gabytm.mastercooldowns.MasterCooldowns;
import me.gabytm.mastercooldowns.cooldown.Cooldown;
import me.gabytm.mastercooldowns.libs.commands.annotations.Alias;
import me.gabytm.mastercooldowns.libs.commands.annotations.Command;
import me.gabytm.mastercooldowns.libs.commands.annotations.Completion;
import me.gabytm.mastercooldowns.libs.commands.annotations.Optional;
import me.gabytm.mastercooldowns.libs.commands.annotations.Permission;
import me.gabytm.mastercooldowns.libs.commands.annotations.SubCommand;
import me.gabytm.mastercooldowns.libs.commands.base.CommandBase;
import me.gabytm.mastercooldowns.utils.Messages;
import me.gabytm.mastercooldowns.utils.NumberUtil;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Command(value="mastercooldowns")
@Alias(value={"cd", "mcd", "mcooldowns", "mcooldown"})
public class AddCooldownCommand
extends CommandBase {
    private MasterCooldowns plugin;

    public AddCooldownCommand(MasterCooldowns plugin) {
        this.plugin = plugin;
    }

    @SubCommand(value="add")
    @Completion(value={"#players"})
    @Permission(value={"mastercooldowns.access"})
    public void onCommand(CommandSender sender, String to, String cdName, String cdDuration, @Optional Boolean accumulateOptional) {
        boolean accumulate;
        boolean onlineSendMessages = this.plugin.getConfig().getBoolean("settings.add.all.onlineSendMessages", true);
        boolean offlineSendMessages = this.plugin.getConfig().getBoolean("settings.add.all.offlineSendMessages", true);
        long duration = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) + NumberUtil.durationToSeconds(cdDuration);
        boolean bl = accumulate = accumulateOptional != null && accumulateOptional != false;
        if (to.equals("*")) {
            if (sender.getServer().getOnlinePlayers().size() == 0) {
                sender.sendMessage(Messages.NO_ONLINE_PLAYERS.value());
                return;
            }
            for (Player p : sender.getServer().getOnlinePlayers()) {
                this.addCooldown(sender, (OfflinePlayer)p, cdName, duration, onlineSendMessages, accumulate);
            }
            return;
        }
        if (to.equals("**")) {
            if (sender.getServer().getOfflinePlayers().length == 0) {
                sender.sendMessage(Messages.NO_OFFLINE_PLAYERS.value());
                return;
            }
            for (OfflinePlayer p : sender.getServer().getOfflinePlayers()) {
                this.addCooldown(sender, p, cdName, duration, offlineSendMessages, accumulate);
            }
            return;
        }
        this.addCooldown(sender, Bukkit.getOfflinePlayer((String)to), cdName, duration, this.plugin.getConfig().getBoolean("settings.add.single.sendMessage", true), accumulate);
    }

    private void addCooldown(@NotNull CommandSender sender, @NotNull OfflinePlayer player, @NotNull String name, long expiration, boolean sendMessages, boolean accumulate) {
        Cooldown cooldown = new Cooldown(player.getUniqueId(), name, expiration);
        this.plugin.getCooldownManager().addCooldown(cooldown, accumulate);
        if (sendMessages) {
            sender.sendMessage(Messages.ADD_INFO.format(cooldown));
        }
    }
}

