/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.mastercooldowns.cooldown;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.gabytm.mastercooldowns.utils.TimeUtil;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class Cooldown
implements Serializable {
    private UUID uuid;
    private String name;
    private long start;
    private long expiration;

    public Cooldown(UUID uuid, String name, long start, long expiration) {
        this.uuid = uuid;
        this.name = name;
        this.start = start;
        this.expiration = expiration;
    }

    public Cooldown(UUID uuid, String name, long expiration) {
        this(uuid, name, TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()), expiration);
    }

    public UUID getPlayerUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public long getStart() {
        return this.start;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public boolean isExpired() {
        return this.getExpiration() <= System.currentTimeMillis() / 1000L;
    }

    public long getTimeLeft() {
        return this.getExpiration() - System.currentTimeMillis() / 1000L <= 0L ? 0L : this.getExpiration() - System.currentTimeMillis() / 1000L;
    }

    public String getTimeLeftFormatted() {
        if (this.getTimeLeft() <= 0L) {
            return "0s";
        }
        long left = this.getExpiration() * 1000L - System.currentTimeMillis();
        return TimeUtil.format((int)TimeUnit.MILLISECONDS.toSeconds(left));
    }

    public OfflinePlayer getPlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.getPlayerUuid());
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }
}

