/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.mastercooldowns.cooldown;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import me.gabytm.mastercooldowns.cooldown.Cooldown;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CooldownManager {
    private final Table<UUID, String, Cooldown> loadedCooldowns = HashBasedTable.create();

    public void loadCooldowns(@NotNull Table<UUID, String, Cooldown> cooldowns) {
        this.loadedCooldowns.putAll(cooldowns);
    }

    @NotNull
    public Table<UUID, String, Cooldown> getLoadedCooldowns() {
        return this.loadedCooldowns;
    }

    @NotNull
    public Collection<Cooldown> getPlayerCooldowns(@NotNull UUID uuid) {
        return this.loadedCooldowns.row((Object)uuid).values();
    }

    @NotNull
    public List<Cooldown> getPlayerActiveCooldowns(@NotNull UUID uuid) {
        return this.getPlayerCooldowns(uuid).stream().filter(it -> !it.isExpired()).collect(Collectors.toList());
    }

    @Nullable
    public Cooldown getCooldownByName(@NotNull UUID uuid, @NotNull String name) {
        return this.getPlayerCooldowns(uuid).stream().filter(it -> it.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public void addCooldown(@NotNull UUID uuid, @NotNull String name, long start, long expiration) {
        this.addCooldown(uuid, name, start, expiration, false);
    }

    public void addCooldown(@NotNull UUID uuid, @NotNull String name, long start, long expiration, boolean accumulate) {
        Cooldown cooldown = this.getCooldownByName(uuid, name);
        if (cooldown == null) {
            this.loadedCooldowns.put((Object)uuid, (Object)name, (Object)new Cooldown(uuid, name.toUpperCase(), start, expiration));
            return;
        }
        if (accumulate) {
            cooldown.setExpiration(cooldown.getExpiration() + (expiration - start));
        } else {
            cooldown.setStart(start);
            cooldown.setExpiration(expiration);
        }
    }

    public void addCooldown(@NotNull Cooldown cooldown) {
        this.addCooldown(cooldown, false);
    }

    public void addCooldown(@NotNull Cooldown cooldown, boolean accumulate) {
        Cooldown existing = this.getCooldownByName(cooldown.getPlayerUuid(), cooldown.getName());
        if (existing == null) {
            this.loadedCooldowns.put((Object)cooldown.getPlayerUuid(), (Object)cooldown.getName(), (Object)cooldown);
            return;
        }
        if (accumulate) {
            existing.setExpiration(existing.getExpiration() + cooldown.getTimeLeft());
        } else {
            existing.setStart(cooldown.getStart());
            existing.setExpiration(cooldown.getExpiration());
        }
    }

    public void removeCooldown(@NotNull UUID uuid, @NotNull String name) {
        Cooldown cooldown = this.getCooldownByName(uuid, name);
        if (cooldown != null) {
            this.removeCooldown(cooldown);
        }
    }

    public void removeCooldown(@NotNull Cooldown cooldown) {
        cooldown.setExpiration(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
    }

    public void renameCooldown(@NotNull UUID uuid, @NotNull String name, @NotNull String newName) {
        Cooldown cooldown = this.getCooldownByName(uuid, name);
        if (cooldown != null) {
            cooldown.setName(newName);
        }
    }
}

