/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.mastercooldowns.libs.commands.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.gabytm.mastercooldowns.libs.commands.base.MessageHandler;
import org.bukkit.command.CommandSender;

public abstract class CommandBase {
    private final Map<String, String> arguments = new HashMap<String, String>();
    private final List<String> aliases = new ArrayList<String>();
    private MessageHandler messageHandler;
    private String command;

    public CommandBase() {
    }

    public CommandBase(String command, List<String> aliases) {
        this.command = command;
        this.aliases.addAll(aliases);
    }

    public String getArgument(String name) {
        return this.arguments.getOrDefault(name, null);
    }

    public void sendMessage(String messageId, CommandSender sender) {
        this.messageHandler.sendMessage(messageId, sender);
    }

    void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    void clearArgs() {
        this.arguments.clear();
    }

    void addArgument(String name, String argument) {
        this.arguments.put(name, argument);
    }

    List<String> getAliases() {
        return this.aliases;
    }

    String getCommand() {
        return this.command;
    }

    public void setAliases(List<String> aliases) {
        this.aliases.addAll(aliases);
    }
}

