/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.timeapi;

import java.util.concurrent.TimeUnit;
import sh.okx.timeapi.TimeScanner;

public class TimeAPI {
    private static final long DAYS_IN_WEEK = 7L;
    private static final long DAYS_IN_MONTH = 30L;
    private static final long DAYS_IN_YEAR = 365L;
    private String ogTime;
    private long seconds;

    public TimeAPI(String time) {
        this.ogTime = time;
        this.reparse(time);
    }

    public TimeAPI(long seconds) {
        this.seconds = seconds;
    }

    public TimeAPI reparse(String time) {
        this.seconds = 0L;
        TimeScanner scanner = new TimeScanner(time.replace(" ", "").replace("and", "").replace(",", "").toLowerCase());
        block44: while (scanner.hasNext()) {
            long next = scanner.nextLong();
            switch (scanner.nextString()) {
                case "s": 
                case "sec": 
                case "secs": 
                case "second": 
                case "seconds": {
                    this.seconds += next;
                    continue block44;
                }
                case "m": 
                case "min": 
                case "mins": 
                case "minute": 
                case "minutes": {
                    this.seconds += TimeUnit.MINUTES.toSeconds(next);
                    continue block44;
                }
                case "h": 
                case "hr": 
                case "hrs": 
                case "hour": 
                case "hours": {
                    this.seconds += TimeUnit.HOURS.toSeconds(next);
                    continue block44;
                }
                case "d": 
                case "dy": 
                case "dys": 
                case "day": 
                case "days": {
                    this.seconds += TimeUnit.DAYS.toSeconds(next);
                    continue block44;
                }
                case "w": 
                case "week": 
                case "weeks": {
                    this.seconds += TimeUnit.DAYS.toSeconds(next * 7L);
                    continue block44;
                }
                case "mo": 
                case "mon": 
                case "mnth": 
                case "month": 
                case "months": {
                    this.seconds += TimeUnit.DAYS.toSeconds(next * 30L);
                    continue block44;
                }
                case "y": 
                case "yr": 
                case "yrs": 
                case "year": 
                case "years": {
                    this.seconds += TimeUnit.DAYS.toSeconds(next * 365L);
                    continue block44;
                }
            }
            throw new IllegalArgumentException();
        }
        return this;
    }

    public String getOgTime() {
        return this.ogTime;
    }

    public long getNanoseconds() {
        return TimeUnit.SECONDS.toNanos(this.seconds);
    }

    public long getMicroseconds() {
        return TimeUnit.SECONDS.toMicros(this.seconds);
    }

    public long getMilliseconds() {
        return TimeUnit.SECONDS.toMillis(this.seconds);
    }

    public long getSeconds() {
        return this.seconds;
    }

    public long getMinutes() {
        return TimeUnit.SECONDS.toMinutes(this.seconds);
    }

    public long getHours() {
        return TimeUnit.SECONDS.toHours(this.seconds);
    }

    public long getDays() {
        return TimeUnit.SECONDS.toDays(this.seconds);
    }

    public long getWeeks() {
        return this.getDays() / 7L;
    }

    public long getMonths() {
        return this.getDays() / 30L;
    }

    public long getYears() {
        return this.getDays() / 365L;
    }

    public long getTicks() {
        return this.seconds * 20L;
    }
}

